/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.captcha;

import java.io.Serializable;

public class Captcha
implements Serializable {
    public static final int DEFAULT_EXPIRE_TIME = 180;
    private String key;
    private String value;
    private long expireAt;

    public Captcha(String key, String value, int expireTime) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key and value can not be null");
        }
        this.key = key;
        this.value = value;
        long et = expireTime;
        this.expireAt = et * 1000L + System.currentTimeMillis();
    }

    public Captcha(String key, String value) {
        this(key, value, 180);
    }

    public Captcha() {
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public long getExpireAt() {
        return this.expireAt;
    }

    public boolean isExpired() {
        return this.expireAt < System.currentTimeMillis();
    }

    public boolean notExpired() {
        return !this.isExpired();
    }

    public String toString() {
        return this.key + " : " + this.value;
    }
}

