/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.captcha;

import com.ydn.web.appserver.captcha.Captcha;
import com.ydn.web.appserver.captcha.ICaptchaCache;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class CaptchaCache
implements ICaptchaCache {
    private Map<String, Captcha> map = new ConcurrentHashMap<String, Captcha>();
    private int interval = 90000;
    private Timer timer;

    public CaptchaCache() {
        this.autoRemoveExpiredCaptcha();
    }

    private void autoRemoveExpiredCaptcha() {
        this.timer = new Timer("CaptchaCache", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (Map.Entry e : CaptchaCache.this.map.entrySet()) {
                    if (!((Captcha)e.getValue()).isExpired()) continue;
                    CaptchaCache.this.map.remove(e.getKey());
                }
            }
        }, this.interval, (long)this.interval);
    }

    @Override
    public void put(Captcha captcha) {
        this.map.put(captcha.getKey(), captcha);
    }

    @Override
    public Captcha get(String key) {
        return key != null ? this.map.get(key) : null;
    }

    @Override
    public void remove(String key) {
        this.map.remove(key);
    }
}

