/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.annotation.Parameter;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.ServerConfiguration;
import com.ydn.web.appserver.util.HttpUtil;
import com.ydn.web.appserver.util.MapUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionContext {
    private static ThreadLocal<ActionContext> threadLocal = new ThreadLocal();
    private ServerConfiguration configuration;
    private Map<String, Object> data;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Action action;
    private long startMillis = 0L;
    private long endMillis = 0L;

    public static void setContext(ActionContext context) {
        threadLocal.set(context);
    }

    public static ActionContext getContext() {
        return threadLocal.get();
    }

    public ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    public void setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    public long getEndMillis() {
        return this.endMillis;
    }

    public void setEndMillis(long endMillis) {
        this.endMillis = endMillis;
    }

    public String getParam(String key) {
        String value = this.request.getParameter(key);
        if (value == null) {
            value = this.getPostParam(key);
        }
        if (value == null) {
            value = this.getDefaultParam(key);
        }
        return value;
    }

    public String[] getInterceptors() {
        return this.action.getAnno().interceptor();
    }

    private String getPostParam(String key) {
        if (this.data == null) {
            this.data = HttpUtil.readData(this.request);
        }
        return MapUtil.getString(this.data, key);
    }

    private String getDefaultParam(String key) {
        for (Parameter param : this.action.getAnno().request()) {
            if (!param.name().equals(key)) continue;
            return param.required() ? null : param.defaultValue();
        }
        return null;
    }
}

