/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.core.ActionContext;
import com.ydn.web.appserver.core.InterceptorChain;

public class ActionInvocation {
    private InterceptorChain interceptors;
    private ActionContext actionContext;
    private FinalInvocation finalInvocation;

    public ActionInvocation(InterceptorChain interceptors, ActionContext actionContext, FinalInvocation finalInvocation) {
        this.interceptors = interceptors;
        this.actionContext = actionContext;
        this.finalInvocation = finalInvocation;
    }

    public void invoke() throws Exception {
        Interceptor next = this.interceptors.next();
        if (next != null) {
            next.intercept(this);
        } else {
            try {
                this.actionContext.setStartMillis(System.currentTimeMillis());
                this.finalInvocation.invoke();
            }
            finally {
                this.actionContext.setEndMillis(System.currentTimeMillis());
            }
        }
    }

    public InterceptorChain getInterceptors() {
        return this.interceptors;
    }

    public ActionContext getActionContext() {
        return this.actionContext;
    }

    public static interface FinalInvocation {
        public void invoke() throws Exception;
    }
}

