/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.core.ActionMappings;
import com.ydn.web.appserver.core.ControllerFactory;
import com.ydn.web.appserver.core.DefaultActionMappings;
import com.ydn.web.appserver.core.DefaultControllerFactory;
import com.ydn.web.appserver.core.DefaultInterceptorFactory;
import com.ydn.web.appserver.core.InterceptorFactory;
import com.ydn.web.appserver.core.ServerConfiguration;
import com.ydn.web.appserver.core.ServerStat;
import com.ydn.web.appserver.core.dispatch.Dispatchers;
import com.ydn.web.appserver.render.DefaultRenderFactory;
import com.ydn.web.appserver.render.RenderFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerCore {
    private ServerConfiguration serverConfiguration;
    private ControllerFactory controllerFactory = new DefaultControllerFactory();
    private ActionMappings actionMappings = new DefaultActionMappings();
    private ServerStat serverStat = new ServerStat();
    private RenderFactory renderFactory = new DefaultRenderFactory();
    private InterceptorFactory interceptorFactory = new DefaultInterceptorFactory();
    private static final Logger logger = LoggerFactory.getLogger(AppServerCore.class);
    private static AppServerCore instance = new AppServerCore();

    public void setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
    }

    public void setPackages(String ... packages) {
        this.actionMappings.setPackages(packages);
    }

    public void addInterceptor(Interceptor interceptor) {
        this.interceptorFactory.addInterceptor(interceptor);
    }

    public void setServerConfiguration(ServerConfiguration configuration) {
        this.serverConfiguration = configuration;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public ActionMappings getActionMappings() {
        return this.actionMappings;
    }

    public RenderFactory getRenderFactory() {
        return this.renderFactory;
    }

    public ControllerFactory getControllerFactory() {
        return this.controllerFactory;
    }

    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public ServerStat getServerStat() {
        return this.serverStat;
    }

    private AppServerCore() {
    }

    public static AppServerCore inst() {
        return instance;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getRequestURI().contains("_console")) {
            Dispatchers.inst().handleConsole(request, response);
        } else {
            Dispatchers.inst().handleAction(request, response);
        }
    }
}

