/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.ContextListener;
import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.WebAppServer;
import com.ydn.web.appserver.core.BeanFactory;
import com.ydn.web.appserver.core.ServerConfiguration;
import com.ydn.web.appserver.spring.SpringServerInjector;
import com.ydn.web.appserver.util.StringUtil;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(AppServerFactory.class);
    public static final String PROPERTY_IP = "ip";
    public static final String PROPERTY_CONTEXT_PATH = "context-path";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_MAX_ACTIVE_WORKERS = "max-active-workers";
    public static final String PROPERTY_CONTROLLER_PACKAGES = "controller-packages";
    public static final String PROPERTY_SPRING_CONFIG = "spring-config";
    public static final String PROPERTY_CONTEXT_LISTENER = "context-listener";
    public static final String PROPERTY_INTERCEPTORS = "interceptors";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";

    public static WebAppServer createServer(Properties properties) {
        String contextPath = AppServerFactory.getProperty(properties, PROPERTY_CONTEXT_PATH, "web");
        String ip = AppServerFactory.getProperty(properties, PROPERTY_IP, "0.0.0.0");
        int port = Integer.parseInt(AppServerFactory.getProperty(properties, PROPERTY_PORT, String.valueOf(8080)));
        int maxActiveWorkers = Integer.parseInt(AppServerFactory.getProperty(properties, PROPERTY_MAX_ACTIVE_WORKERS, String.valueOf(ServerConfiguration.DEFAULT_MAX_PROCESSORS)));
        WebAppServer server = new WebAppServer(contextPath, ip, port, maxActiveWorkers);
        AppServerFactory.configServer(properties, server);
        return server;
    }

    private static void configServer(Properties properties, WebAppServer server) {
        String password;
        String username;
        String interceptors;
        String contextListenerClassName;
        String packages;
        String springConfigFile = properties.getProperty(PROPERTY_SPRING_CONFIG);
        if (StringUtil.isNotEmpty(springConfigFile)) {
            SpringServerInjector.inject(server, springConfigFile);
        }
        if (StringUtil.isNotEmpty(packages = properties.getProperty(PROPERTY_CONTROLLER_PACKAGES))) {
            server.setPackages(packages.split(","));
        }
        if (StringUtil.isNotEmpty(contextListenerClassName = properties.getProperty(PROPERTY_CONTEXT_LISTENER))) {
            AppServerFactory.initListener(server, contextListenerClassName);
        }
        if (StringUtil.isNotEmpty(interceptors = properties.getProperty(PROPERTY_INTERCEPTORS))) {
            AppServerFactory.initInterceptors(server, interceptors);
        }
        if (StringUtil.isNotEmpty(username = properties.getProperty(PROPERTY_USERNAME))) {
            server.setAdminUser(username);
        }
        if (StringUtil.isNotEmpty(password = properties.getProperty(PROPERTY_PASSWORD))) {
            server.setAdminPwd(password);
        }
    }

    private static void initInterceptors(WebAppServer server, String interceptors) {
        for (String clazz : interceptors.split(",")) {
            Interceptor interceptor;
            if (!StringUtil.isNotEmpty(clazz) || (interceptor = (Interceptor)BeanFactory.getBeanByClass(server, clazz)) == null) continue;
            server.addInterceptor(interceptor);
        }
    }

    private static void initListener(WebAppServer server, String contextListenerClassName) {
        ContextListener listener = (ContextListener)BeanFactory.getBeanByClass(server, contextListenerClassName);
        if (listener != null) {
            server.setContextListener(listener);
        }
    }

    protected static String getProperty(Properties properties, String key, String defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }
}

