/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.AppServerException;
import com.ydn.web.appserver.WebAppServer;
import com.ydn.web.appserver.spring.SpringServerInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanFactory {
    private static final Logger logger = LoggerFactory.getLogger(BeanFactory.class);

    public static <T> T getBeanByClass(WebAppServer webAppServer, String className) {
        T result = null;
        if (webAppServer.getProperty("spring-app-context") != null) {
            try {
                result = SpringServerInjector.getBeanByClass(webAppServer, className);
            }
            catch (Exception e) {
                logger.info("Class '" + className + "' not found in Spring context.");
            }
        }
        if (result == null) {
            try {
                result = (T)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new AppServerException(e);
            }
        }
        return result;
    }
}

