/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CompositeResourceManager
implements ResourceManager {
    private static final String CLASSPATH = "classpath:";
    private List<ResourceManager> list = new ArrayList<ResourceManager>();

    public CompositeResourceManager(String ... paths) {
        for (String path : paths) {
            if (path.startsWith(CLASSPATH)) {
                this.list.add((ResourceManager)this.newClassPathResourceManager(path.substring(CLASSPATH.length())));
                continue;
            }
            this.list.add((ResourceManager)this.newFileResourceManager(path));
        }
    }

    public Resource getResource(String path) throws IOException {
        for (ResourceManager rm : this.list) {
            Resource ret = rm.getResource(path);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        for (ResourceManager rm : this.list) {
            if (!rm.isResourceChangeListenerSupported()) continue;
            return true;
        }
        return false;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager rm : this.list) {
            rm.registerResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        for (ResourceManager rm : this.list) {
            if (!rm.isResourceChangeListenerSupported()) continue;
            rm.removeResourceChangeListener(listener);
        }
    }

    public void close() throws IOException {
        for (ResourceManager rm : this.list) {
            rm.close();
        }
    }

    private FileResourceManager newFileResourceManager(String path) {
        return new FileResourceManager(new File(path));
    }

    private ClassPathResourceManager newClassPathResourceManager(String path) {
        return new ClassPathResourceManager(CompositeResourceManager.class.getClassLoader(), path);
    }
}

