/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.AppServerException;
import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.annotation.Controller;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.ConsoleContext;
import com.ydn.web.appserver.core.ServerConfiguration;
import com.ydn.web.appserver.util.JwtUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ConsoleHandler {
    private static Map<Controller, List<Action>> dic = new HashMap<Controller, List<Action>>();
    protected static final String KEY = "web-app-server";
    protected static final String CONTENT_TYPE = "text/html; charset=utf-8";
    protected static final String CONTEXT_PATH = "##contextPath##";
    protected static final String MENU = "##menu##";
    protected static final String NAV = "##nav##";
    protected static final String SUBNAV = "##subnav##";
    protected static final String HREF = "##href##";
    protected static final String JWT_SECRET = "webapp";
    protected static final Integer JWT_EXPIRE = 86400;
    protected static final String aside_pattern = "<aside class=\"lyear-layout-sidebar\">   <div class=\"sidebar-header\">       <a href=\"index\" style=\"height:68px;\"><img src=\"##contextPath##/dist/img/logo.png\" style=\"height:40px;\"></a>   </div>   <div class=\"lyear-layout-sidebar-scroll\">       <nav class=\"sidebar-main\">           <ul class=\"nav nav-drawer\">               %s           </ul>       </nav>   </div></aside>";
    protected static final String header_pattern = "<header class=\"lyear-layout-header\">   <nav class=\"navbar navbar-default\">       <div class=\"topbar\">           <div class=\"topbar-left\">               <div class=\"lyear-aside-toggler\">                   <span class=\"lyear-toggler-bar\"></span>                   <span class=\"lyear-toggler-bar\"></span>                   <span class=\"lyear-toggler-bar\"></span>               </div>               <span class=\"navbar-page-title\">%s</span>           </div>           <ul class=\"topbar-right\">               <li class=\"dropdown dropdown-profile\">                   <a href=\"javascript:void(0)\" data-toggle=\"dropdown\">                           <img class=\"img-avatar img-avatar-48 m-r-10\" src=\"##contextPath##/dist/img/avatar.png\">                           <span>\u7ba1\u7406\u5458<i class=\"caret\"></i></span>                   </a>                   <ul class=\"dropdown-menu dropdown-menu-right\">                       <li><a href=\"javascript:void(0)\" id=\"logoutBtn\"><i class=\"mdi mdi-logout-variant\"></i> \u9000\u51fa\u767b\u5f55</a></li>                   </ul>               </li>           </ul>       </div>   </nav></header>";

    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConsoleContext consoleContext = ConsoleContext.getContext();
        if (consoleContext == null) {
            consoleContext = new ConsoleContext();
            ConsoleContext.setContext(consoleContext);
        }
        consoleContext.setRequest(request);
        consoleContext.setResponse(response);
        this.doHandle();
    }

    protected abstract void doHandle();

    protected boolean checkAt() {
        return this.checkAt(this.getCookie("at"));
    }

    protected void renderRedirect(String url) {
        AppServerCore.inst().getRenderFactory().getRedirectRender(url).setContext(ConsoleContext.getContext().getRequest(), ConsoleContext.getContext().getResponse()).render();
    }

    protected void renderJson(Result result) {
        AppServerCore.inst().getRenderFactory().getJsonRender(result).setContext(ConsoleContext.getContext().getRequest(), ConsoleContext.getContext().getResponse()).render();
    }

    protected void renderHtml(String string) {
        try {
            ConsoleContext.getContext().getResponse().setContentType(CONTENT_TYPE);
            ConsoleContext.getContext().getResponse().getWriter().write(string);
        }
        catch (IOException e) {
            throw new AppServerException(e);
        }
    }

    protected String aside(Action action) {
        return String.format(aside_pattern, this.newMenus(action));
    }

    protected String header(Action action) {
        return String.format(header_pattern, action == null ? "\u9996\u9875" : action.getRes().desc());
    }

    public ServerConfiguration getConfiguration() {
        return AppServerCore.inst().getServerConfiguration();
    }

    public String getAdminUser() {
        return this.getConfiguration().getAdminUser();
    }

    public String getAdminPwd() {
        return this.getConfiguration().getAdminPwd();
    }

    public String getContextPath() {
        return "/" + this.getConfiguration().getContextPath();
    }

    public String getString(String key) {
        return ConsoleContext.getContext().getParam(key);
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = ConsoleContext.getContext().getParam(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = ConsoleContext.getContext().getParam(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = ConsoleContext.getContext().getParam(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public void setCookie(String name, String value, int maxAgeInSeconds, boolean isHttpOnly) {
        this.doSetCookie(name, value, maxAgeInSeconds, null, null, isHttpOnly);
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = ConsoleContext.getContext().getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void removeCookie(String name) {
        this.doSetCookie(name, null, 0, null, null, null);
    }

    public Action getAction(String act) {
        return AppServerCore.inst().getActionMappings().find(act);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newMenus(Action act) {
        if (dic.isEmpty()) {
            Map<Controller, List<Action>> map = dic;
            synchronized (map) {
                if (dic.isEmpty()) {
                    this.classify();
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Controller, List<Action>> entry : dic.entrySet()) {
            builder.append(this.nav(entry, act));
        }
        return builder.toString();
    }

    private String nav(Map.Entry<Controller, List<Action>> entry, Action act) {
        StringBuilder builder = new StringBuilder();
        if (act != null && entry.getKey().value().equals(act.getRes().value())) {
            builder.append("<li class=\"nav-item nav-item-has-subnav open\">\n");
        } else {
            builder.append("<li class=\"nav-item nav-item-has-subnav\">\n");
        }
        builder.append("<a href=\"javascript:void(0)\"><i class=\"mdi mdi-format-align-justify\"></i> ##nav##</a>\n".replaceAll(NAV, entry.getKey().desc()));
        builder.append(this.subNav(entry.getValue(), act));
        builder.append("</li>\n");
        return builder.toString();
    }

    private String subNav(List<Action> list, Action act) {
        StringBuilder builder = new StringBuilder();
        builder.append("<ul class=\"nav nav-subnav\">\n");
        list.sort((o1, o2) -> o1.getAnno().value().compareTo(o2.getAnno().value()));
        for (Action action : list) {
            if (act != null && action.getAnno().value().equals(act.getAnno().value()) && action.getRes().value().equals(act.getRes().value())) {
                builder.append("<li class=\"active\"><a href=\"##href##\">##subnav##</a></li>\n".replaceAll(HREF, "action?act=" + action.getRes().value() + action.getAnno().value()).replaceAll(SUBNAV, action.getAnno().desc()));
                continue;
            }
            builder.append("<li><a href=\"##href##\">##subnav##</a></li>\n".replaceAll(HREF, "action?act=" + action.getRes().value() + action.getAnno().value()).replaceAll(SUBNAV, action.getAnno().desc()));
        }
        builder.append("</ul>\n");
        return builder.toString();
    }

    private void classify() {
        AppServerCore.inst().getActionMappings().list().stream().forEach(a -> {
            if (!dic.containsKey(a.getRes())) {
                dic.put(a.getRes(), new ArrayList());
            }
            dic.get(a.getRes()).add((Action)a);
        });
    }

    private void doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly.booleanValue());
        }
        ConsoleContext.getContext().getResponse().addCookie(cookie);
    }

    private boolean checkAt(String at) {
        if (at == null) {
            return false;
        }
        try {
            JwtUtil.getClaim(at, JWT_SECRET);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

