/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.AbstractController;
import com.ydn.web.appserver.annotation.Controller;
import com.ydn.web.appserver.annotation.RequestMapping;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.ActionMappings;
import com.ydn.web.appserver.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActionMappings
implements ActionMappings {
    private Map<String, Action> mappings;
    private List<String> packages = new ArrayList<String>();
    private static final Logger logger = LoggerFactory.getLogger(DefaultActionMappings.class);

    public DefaultActionMappings() {
        this.mappings = new HashMap<String, Action>();
    }

    @Override
    public void setPackages(String ... packages) {
        for (String aPackage : packages) {
            this.addPackage(aPackage);
        }
    }

    @Override
    public void addPackage(String aPackage) {
        if (!this.packages.contains(aPackage)) {
            this.packages.add(aPackage);
            this.lookup(aPackage);
        }
    }

    @Override
    public void addClass(Class<? extends AbstractController> aClass) {
        this.doLookup(aClass);
    }

    @Override
    public Action find(String route) {
        return this.mappings.get(route);
    }

    @Override
    public List<Action> list() {
        return new ArrayList<Action>(this.mappings.values());
    }

    private void lookup(String aPackage) {
        try {
            List<Class<AbstractController>> clazzs = ClassUtils.findClasses(AbstractController.class, aPackage);
            for (Class<AbstractController> clazz : clazzs) {
                this.doLookup(clazz);
            }
        }
        catch (SecurityException e) {
            logger.error("", (Throwable)e);
        }
    }

    private void doLookup(Class<? extends AbstractController> clazz) {
        Controller res = null;
        if (clazz.isAnnotationPresent(Controller.class)) {
            res = clazz.getAnnotation(Controller.class);
        }
        if (res != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(RequestMapping.class)) continue;
                RequestMapping anno = method.getAnnotation(RequestMapping.class);
                this.mappings.put(this.route(res.value(), anno.value()), new Action(clazz, method, res, anno));
            }
        }
    }

    private String route(String prefix, String action) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            if (!prefix.startsWith("/")) {
                builder.append("/");
            }
            builder.append(prefix);
        }
        if (!action.startsWith("/")) {
            builder.append("/");
        }
        builder.append(action);
        return builder.toString();
    }
}

