/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core;

import com.ydn.web.appserver.core.ActionStat;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.PrefStat;
import com.ydn.web.appserver.core.ReqStat;
import com.ydn.web.appserver.util.Counter;
import com.ydn.web.appserver.util.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ServerStat {
    private final Map<String, ActionStat> stats = new HashMap<String, ActionStat>();
    private final Map<String, Counter> daily = new HashMap<String, Counter>();
    private final Map<String, Counter> monthly = new HashMap<String, Counter>();
    private final long ctime = DateUtil.now();
    private AtomicInteger total = new AtomicInteger(0);

    public void succ(String actionName, long elapse) {
        ActionStat stat = this.getStat(actionName);
        stat.succ(elapse);
        this.addDaily();
        this.addMonthly();
        this.total.incrementAndGet();
    }

    public void fail(String actionName, long elapse, Exception e) {
        ActionStat stat = this.getStat(actionName);
        stat.fail(elapse, e);
        this.addDaily();
        this.addMonthly();
        this.total.incrementAndGet();
    }

    public List<ActionStat> getStats() {
        return new ArrayList<ActionStat>(this.stats.values());
    }

    public List<ReqStat> getReqStats() {
        ArrayList<ReqStat> result = new ArrayList<ReqStat>();
        ArrayList<ActionStat> snapshots = new ArrayList<ActionStat>(this.stats.values());
        snapshots.stream().forEach(a -> result.add(new ReqStat(a.getName(), a.getDesc(), a.getTotalCnt())));
        return result;
    }

    public List<PrefStat> getPrefStats() {
        ArrayList<PrefStat> result = new ArrayList<PrefStat>();
        ArrayList<ActionStat> snapshots = new ArrayList<ActionStat>(this.stats.values());
        snapshots.stream().forEach(a -> result.add(new PrefStat(a.getName(), a.getDesc(), (double)a.getTotalCst().longValue() * 1.0 / (double)a.getTotalCnt().longValue())));
        return result;
    }

    public int getDaily() {
        String date = DateUtil.getDate();
        return this.daily.containsKey(date) ? this.daily.get(date).getNum() : 0;
    }

    public int getMonthly() {
        String month = DateUtil.getMonth();
        return this.monthly.containsKey(month) ? this.monthly.get(month).getNum() : 0;
    }

    public long getCtime() {
        return this.ctime;
    }

    public int getTotal() {
        return this.total.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionStat getStat(String actionName) {
        ActionStat stat = this.stats.get(actionName);
        if (stat == null) {
            Map<String, ActionStat> map = this.stats;
            synchronized (map) {
                stat = this.stats.get(actionName);
                if (stat == null) {
                    stat = new ActionStat(actionName, this.getDesc(actionName));
                    this.stats.put(actionName, stat);
                }
            }
        }
        return stat;
    }

    private String getDesc(String actionName) {
        return AppServerCore.inst().getActionMappings().find(actionName).getAnno().desc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDaily() {
        String date = DateUtil.getDate();
        if (!this.daily.containsKey(date)) {
            Map<String, Counter> map = this.daily;
            synchronized (map) {
                if (!this.daily.containsKey(date)) {
                    this.daily.put(date, new Counter());
                }
            }
        }
        this.daily.get(date).inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonthly() {
        String month = DateUtil.getMonth();
        if (!this.monthly.containsKey(month)) {
            Map<String, Counter> map = this.monthly;
            synchronized (map) {
                if (!this.monthly.containsKey(month)) {
                    this.monthly.put(month, new Counter());
                }
            }
        }
        this.monthly.get(month).inc();
    }
}

