/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core.console;

import com.alibaba.fastjson.JSON;
import com.ydn.web.appserver.annotation.Parameter;
import com.ydn.web.appserver.annotation.PropType;
import com.ydn.web.appserver.annotation.Property;
import com.ydn.web.appserver.annotation.RequestMapping;
import com.ydn.web.appserver.annotation.Sheet;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.ConsoleHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ActionHandler
extends ConsoleHandler {
    private static final String breadcrumb_pattern = "<div class=\"row action-header\">   <ol class=\"breadcrumb\">       <li>%s</li>       <li>%s</li>   </ol></div>";
    private static final String doc_pattern = "<div class=\"tab-pane fade in active\" id=\"doc\">   <div>       <h3 class=\"magin-v-20\">\u8bf7\u6c42\u65b9\u5f0f/\u8def\u5f84</h3>       <p>           %s           <span class=\"fontsize-16 m-l-5\" id=\"url\">%s</span>       </p>   </div>   <div>       <h3 class=\"magin-v-40\">\u8bf7\u6c42\u53c2\u6570</h3>       <table class=\"table table-hover table-bordered\">           <thead class=\"color-gray\">               <tr>                   <th>\u5b57\u6bb5\u540d\u79f0</th>                   <th>\u5b57\u6bb5\u63cf\u8ff0</th>                   <th>\u5b57\u6bb5\u7c7b\u578b</th>                   <th>\u662f\u5426\u5fc5\u586b</th>                   <th>\u9ed8\u8ba4\u503c</th>               </tr>           </thead>           <tbody>%s           </tbody>       </table>   </div>   <div>       <h3 class=\"magin-v-40\">\u8fd4\u56de\u7ed3\u679c</h3>       <table class=\"table table-hover table-bordered\">           <thead class=\"color-gray\">               <tr>                   <th>\u5c5e\u6027\u540d\u79f0</th>                   <th>\u5c5e\u6027\u7c7b\u578b</th>                   <th>\u5c5e\u6027\u63cf\u8ff0</th>              </tr>           </thead>           <tbody>%s           </tbody>       </table>%s   </div>   <div>       <h3 class=\"magin-v-40\">\u8fd4\u56de\u793a\u4f8b</h3>       <pre>%s       </pre>   </div></div>";
    private static final String ink_pattern = "<div class=\"tab-pane fade\" id=\"ink\">%s   <div>       <h3 class=\"magin-v-40\">\u8fd4\u56de\u6570\u636e</h3>       <pre id=\"res\">       </pre>   </div></div>";
    private static final String script_pattern = " $(\"#btnSub\").click(function () {   $(\"#aform\").validate({       submitHandler: function () {           var p = {};           var f = $(\"#aform\").serializeArray();           $.each(f, function () { p[this.name] = this.value });           $.ajax({               \"type\": \"%s\",               \"url\": \"%s\",               \"dataType\": \"json\",               \"data\": p,               success: function (result) {                   $(\"#res\").text(JSON.stringify(result, null, 2));               },               error: function () { alert('\u7f51\u7edc\u5f02\u5e38'); }           });       }   });});";
    private static final String HTML = "<!DOCTYPE html><html lang=\"en\"><head>    <meta charset=\"UTF-8\">    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">    <title>Action</title>    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/bootstrap/css/bootstrap.min.css\">    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/material/css/materialdesignicons.min.css\">    <link rel=\"stylesheet\" href=\"##contextPath##/dist/css/style.css\">    <link rel=\"stylesheet\" href=\"##contextPath##/dist/css/action.css\">    <link rel=\"icon\" href=\"##contextPath##/dist/img/favicon.ico\"></head><body><div class=\"lyear-layout-web\">    <div class=\"lyear-layout-container\">%s%s        <main class=\"lyear-layout-content\">            <div class=\"container-fluid\">%s                    <div class=\"action-content\">                        <div class=\"row\">                            <ul class=\"nav nav-tabs pull-right\">                                <li class=\"active\">                                    <a href=\"#doc\" data-toggle=\"tab\">\u63a5\u53e3\u8bf4\u660e</a>                                </li>                                <li>                                    <a href=\"#ink\" data-toggle=\"tab\">\u63a5\u53e3\u8c03\u7528</a>                                </li>                            </ul>                        </div>                        <div class=\"row padding-h-30\">                            <div class=\"tab-content\">%s%s                            </div>                        </div>                    </div>            </div>        </main>    </div></div><script src=\"##contextPath##/plugin/jquery/jquery-3.5.1.js\"></script><script src=\"##contextPath##/plugin/jquery/jquery.validate.js\"></script><script src=\"##contextPath##/plugin/bootstrap/js/bootstrap.min.js\"></script><script src=\"##contextPath##/plugin/scrollbar/js/perfect-scrollbar.min.js\"></script><script src=\"##contextPath##/plugin/chart/js/Chart.js\"></script><script src=\"##contextPath##/dist/js/main.js\"></script><script>    $(document).ready(function (e) {       $('#url').text(location.host+$('#url').text());%s       $('#logoutBtn').click(function(){           $.get('doLogout', function(result){               if(result.errcode === 0) {                   $(window).attr(\"location\", \"login\");               }           });       });    });</script></body></html>";

    @Override
    protected void doHandle() {
        if (!this.checkAt()) {
            this.renderRedirect("_console/login");
        }
        Action action = this.getAction(this.getString("act"));
        this.renderHtml(String.format(HTML, this.aside(action), this.header(action), this.breadcrumb(action), this.doc(action), this.ink(action), this.script(action)).replaceAll("##contextPath##", this.getContextPath()));
    }

    private String breadcrumb(Action action) {
        return String.format(breadcrumb_pattern, action.getRes().desc(), action.getAnno().desc());
    }

    private String doc(Action action) {
        return String.format(doc_pattern, this.methodStr(action), this.uriStr(action), this.parameterStr(action), this.propertyStr(action), this.sheetStr(action), this.respStr(action));
    }

    private String script(Action action) {
        return String.format(script_pattern, this.typeStr(action), this.uriStr(action));
    }

    private String typeStr(Action action) {
        String method = "GET";
        switch (action.getAnno().method().name()) {
            case "POST": {
                method = "POST";
            }
        }
        return method;
    }

    private String methodStr(Action action) {
        StringBuilder builder = new StringBuilder();
        switch (action.getAnno().method().name()) {
            case "ALL": {
                builder.append("<span class=\"label label-warning\">ALL</span>");
                break;
            }
            case "GET": {
                builder.append("<span class=\"label label-success\">GET</span>");
                break;
            }
            case "POST": {
                builder.append("<span class=\"label label-primary\">POST</span>");
                break;
            }
            default: {
                builder.append("<span class=\"label label-danger\">" + action.getAnno().method().name() + "</span>");
            }
        }
        return builder.toString();
    }

    private String uriStr(Action action) {
        return this.getContextPath() + action.getRes().value() + action.getAnno().value();
    }

    private String parameterStr(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().request().length == 0) {
            builder.append("<tr>");
            builder.append("\t<td colspan=5>\u65e0</td>");
            builder.append("</tr>");
        } else {
            for (Parameter parameter : action.getAnno().request()) {
                builder.append(this.newParameter(parameter));
            }
        }
        return builder.toString();
    }

    private String newParameter(Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("\t<td>" + parameter.name() + "</td>");
        builder.append("\t<td>" + parameter.desc() + "</td>");
        builder.append("\t<td>" + parameter.type().name() + "</td>");
        builder.append("\t<td>" + (parameter.required() ? "<span class=\"label label-warning\">\u5fc5\u586b</span>" : "\u53ef\u9009") + "</td>");
        builder.append("\t<td>" + parameter.defaultValue() + "</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    private String propertyStr(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().response().length == 0) {
            builder.append("<tr>");
            builder.append("\t<td colspan=\"3\">\u65e0</td>");
            builder.append("</tr>");
        } else {
            for (Property property : action.getAnno().response()) {
                builder.append(this.newProperty(property));
            }
        }
        return builder.toString();
    }

    private String newProperty(Property property) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("\t<td>" + property.name() + "</td>");
        builder.append("\t<td>" + property.type().name() + "</td>");
        builder.append("\t<td>" + property.desc() + "</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    private String sheetStr(Action act) {
        StringBuilder builder = new StringBuilder();
        for (Sheet sheet : act.getAnno().sheets()) {
            builder.append(this.newSheet(sheet));
        }
        return builder.toString();
    }

    private String newSheet(Sheet sheet) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        builder.append("\t<h4 class=\"magin-v-40\">" + sheet.name() + "</h4>");
        builder.append("\t<table class=\"table table-hover table-bordered\">");
        builder.append("\t\t<thead class=\"color-gray\">");
        builder.append("\t\t\t<tr>");
        builder.append("\t\t\t\t<th>\u5c5e\u6027\u540d\u79f0</th>");
        builder.append("\t\t\t\t<th>\u5c5e\u6027\u7c7b\u578b</th>");
        builder.append("\t\t\t\t<th>\u5c5e\u6027\u63cf\u8ff0</th>");
        builder.append("\t\t\t</tr>");
        builder.append("\t\t</thead>");
        builder.append("\t\t<tbody>");
        builder.append(this.newProperties(sheet));
        builder.append("\t\t</tbody>");
        builder.append("\t</table>");
        builder.append("</div>");
        return builder.toString();
    }

    private String newProperties(Sheet sheet) {
        StringBuilder builder = new StringBuilder();
        if (sheet.props().length == 0) {
            builder.append("<tr>");
            builder.append("\t<td colspan=\"3\">\u65e0</td>");
            builder.append("</tr>");
        } else {
            for (Property property : sheet.props()) {
                builder.append(this.newProperty(property));
            }
        }
        return builder.toString();
    }

    private String ink(Action action) {
        return String.format(ink_pattern, this.inkStr(action));
    }

    private String inkStr(Action action) {
        StringBuilder builder = new StringBuilder();
        builder.append("<form id=\"aform\" action=\"" + this.getContextPath() + action.getRes().value() + action.getAnno().value() + "\" method=\"" + (Object)((Object)action.getAnno().method()) + "\" onSubmit=\"return false\">");
        builder.append("<div>");
        builder.append("\t<h3 class=\"magin-v-40\">\u8bf7\u6c42\u53c2\u6570</h3>");
        builder.append("\t<table class=\"table table-hover table-bordered\">");
        builder.append("\t\t<thead class=\"color-gray\">");
        builder.append("\t\t\t<tr>");
        builder.append("\t\t\t\t<th>\u5b57\u6bb5\u540d\u79f0</th>");
        builder.append("\t\t\t\t<th>\u5b57\u6bb5\u8bf4\u660e</th>");
        builder.append("\t\t\t\t<th>\u5b57\u6bb5\u7c7b\u578b</th>");
        builder.append("\t\t\t\t<th>\u8f93\u5165</th>");
        builder.append("\t\t\t</tr>");
        builder.append("\t\t</thead>");
        builder.append("\t\t<tbody>");
        builder.append(this.newRequest(action));
        builder.append("\t\t</tbody>");
        builder.append("\t</table>");
        builder.append("</div>");
        builder.append("<div class=\"clearfix\">");
        builder.append("\t<button class=\"btn btn-primary pull-right\" id=\"btnSub\">\u63d0\u4ea4</button>");
        builder.append("</div>");
        builder.append("</form>");
        return builder.toString();
    }

    private String newRequest(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().request().length == 0) {
            builder.append("<tr>");
            builder.append("\t<td colspan=\"4\">\u65e0</td>");
            builder.append("</tr>");
        } else {
            for (Parameter parameter : action.getAnno().request()) {
                builder.append(this.newRequest(parameter));
            }
        }
        return builder.toString();
    }

    private String newRequest(Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("\t<td>" + parameter.desc() + "</td>");
        builder.append("\t<td>" + parameter.name() + "</td>");
        builder.append("\t<td>" + parameter.type().name() + "</td>");
        builder.append("\t<td>");
        builder.append("\t\t<input class=\"form-control\" type=\"text\" name=\"" + parameter.name() + "\" " + (parameter.required() ? "placeholder=\"\u5fc5\u9009\" required" : "") + " >");
        builder.append("\t</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    private String respStr(Action action) {
        return JSON.toJSONString(this.respDemo(action), (boolean)true);
    }

    private Map<String, Object> respDemo(Action action) {
        HashMap<String, Object> demo = new HashMap<String, Object>();
        for (Property property : action.getAnno().response()) {
            demo.put(property.name(), this.propDemo(action.getAnno(), property));
        }
        return demo;
    }

    private Map<String, Object> sheetDemo(RequestMapping anno, Sheet sheet) {
        HashMap<String, Object> demo = new HashMap<String, Object>();
        for (Property prop : sheet.props()) {
            demo.put(prop.name(), this.propDemo(anno, prop));
        }
        return demo;
    }

    private Object propDemo(RequestMapping anno, Property property) {
        if (property.type() == PropType.STRING) {
            return "";
        }
        if (property.type() == PropType.INTEGER) {
            return 0;
        }
        if (property.type() == PropType.DECIMAL) {
            return 0.0;
        }
        if (property.type() == PropType.DATE) {
            return new Date();
        }
        if (property.type() == PropType.SHEET) {
            return this.sheetDemo(anno, this.getSheet(property.name(), anno));
        }
        return null;
    }

    private Sheet getSheet(String name, RequestMapping anno) {
        for (Sheet sheet : anno.sheets()) {
            if (!sheet.name().equals(name)) continue;
            return sheet;
        }
        return null;
    }
}

