/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.console.ActionHandler;
import com.ydn.web.appserver.core.console.AdminLoginHandler;
import com.ydn.web.appserver.core.console.AdminLogoutHandler;
import com.ydn.web.appserver.core.console.IndexHandler;
import com.ydn.web.appserver.core.console.LoginHandler;
import com.ydn.web.appserver.core.console.PerfStatHandler;
import com.ydn.web.appserver.core.console.ReqStatHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleHandlers {
    private static ConsoleHandlers instance = new ConsoleHandlers();
    private static final Logger logger = LoggerFactory.getLogger(ConsoleHandlers.class);
    private AdminLoginHandler adminLoginHandler = new AdminLoginHandler();
    private AdminLogoutHandler adminLogoutHandler = new AdminLogoutHandler();
    private LoginHandler loginHandler = new LoginHandler();
    private IndexHandler indexHandler = new IndexHandler();
    private ActionHandler actionHandler = new ActionHandler();
    private ReqStatHandler rstatHandler = new ReqStatHandler();
    private PerfStatHandler pstatHandler = new PerfStatHandler();

    private ConsoleHandlers() {
    }

    public static ConsoleHandlers inst() {
        return instance;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        switch (this.route(request)) {
            case "doLogin": {
                this.adminLoginHandler.handle(request, response);
                break;
            }
            case "doLogout": {
                this.adminLogoutHandler.handle(request, response);
                break;
            }
            case "login": {
                this.loginHandler.handle(request, response);
                break;
            }
            case "index": {
                this.indexHandler.handle(request, response);
                break;
            }
            case "action": {
                this.actionHandler.handle(request, response);
                break;
            }
            case "rstat": {
                this.rstatHandler.handle(request, response);
                break;
            }
            case "pstat": {
                this.pstatHandler.handle(request, response);
            }
        }
    }

    private String route(HttpServletRequest request) {
        String contextPath = AppServerCore.inst().getServerConfiguration().getContextPath();
        int length = contextPath.length();
        if (!contextPath.startsWith("/")) {
            ++length;
        }
        return request.getRequestURI().substring(length + 10);
    }
}

