/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.ConsoleHandler;
import com.ydn.web.appserver.core.ServerStat;

public class IndexHandler
extends ConsoleHandler {
    private static final String ctime_pattern = "<div class=\"col-sm-6 col-lg-3\">   <div class=\"card bg-primary\">       <div class=\"card-body clearfix\">           <div class=\"pull-right\">               <p class=\"h6 text-white m-t-0\">\u5df2\u8fd0\u884c</p>               <p class=\"h3 text-white m-b-0 fa-1-5x\" id=\"duration\">%d</p>           </div>           <div class=\"pull-left\">               <span class=\"img-avatar img-avatar-48 bg-translucent\"><i class=\"mdi mdi-desktop-mac fa-1-5x\"></i></span>           </div>       </div>    </div></div>";
    private static final String daily_pattern = "<div class=\"col-sm-6 col-lg-3\">   <div class=\"card bg-danger\">       <div class=\"card-body clearfix\">           <div class=\"pull-right\">               <p class=\"h6 text-white m-t-0\">\u65e5\u8bf7\u6c42\u91cf</p>               <p class=\"h3 text-white m-b-0 fa-1-5x\">%d</p>           </div>           <div class=\"pull-left\">               <span class=\"img-avatar img-avatar-48 bg-translucent\"><i class=\"mdi mdi-view-day fa-1-5x\"></i></span>           </div>       </div>   </div></div>";
    private static final String monthly_pattern = "<div class=\"col-sm-6 col-lg-3\">   <div class=\"card bg-success\">       <div class=\"card-body clearfix\">           <div class=\"pull-right\">               <p class=\"h6 text-white m-t-0\">\u6708\u8bf7\u6c42\u91cf</p>               <p class=\"h3 text-white m-b-0 fa-1-5x\">%d</p>           </div>           <div class=\"pull-left\">               <span class=\"img-avatar img-avatar-48 bg-translucent\"><i class=\"mdi mdi-view-list fa-1-5x\"></i></span>           </div>       </div>   </div></div>";
    private static final String total_pattern = "<div class=\"col-sm-6 col-lg-3\">   <div class=\"card bg-purple\">       <div class=\"card-body clearfix\">           <div class=\"pull-right\">               <p class=\"h6 text-white m-t-0\">\u603b\u8bf7\u6c42\u91cf</p>               <p class=\"h3 text-white m-b-0 fa-1-5x\">%d</p>           </div>           <div class=\"pull-left\">               <span class=\"img-avatar img-avatar-48 bg-translucent\"><i class=\"mdi mdi-view-dashboard fa-1-5x\"></i></span>           </div>       </div>   </div></div>";
    private static final String rstat_pattern = "<div class=\"card\">   <div class=\"card-header\">       <h4>\u8bf7\u6c42\u7edf\u8ba1</h4>   </div>   <div class=\"card-body\">       <table class=\"table table-bordered table-hover\">           <thead>               <tr>                   <th>\u63a5\u53e3\u540d\u79f0</th>                   <th>\u63a5\u53e3\u63cf\u8ff0</th>                   <th>\u8bf7\u6c42\u6b21\u6570</th>               </tr>           </thead>           <tbody id=\"rstat\">               <tr>                   <td colspan=\"3\">\u65e0</td>               </tr>           </tbody>       </table>       <nav>           <ul class=\"pager\">               <li><a href=\"javascript:void(0)\" id=\"rpriv\">\u4e0a\u4e00\u9875</a></li>               <li><a href=\"javascript:void(0)\" id=\"rnext\">\u4e0b\u4e00\u9875</a></li>           </ul>       </nav>   </div></div>";
    private static final String pstat_pattern = "<div class=\"card\">   <div class=\"card-header\">       <h4>\u6027\u80fd\u7edf\u8ba1</h4>   </div>   <div class=\"card-body\">       <table class=\"table table-bordered table-hover\">           <thead>               <tr>                   <th>\u63a5\u53e3\u540d\u79f0</th>                   <th>\u63a5\u53e3\u63cf\u8ff0</th>                   <th>\u8bf7\u6c42\u65f6\u957f(ms)</th>               </tr>           </thead>           <tbody  id=\"pstat\">               <tr>                   <td colspan=\"3\">\u65e0</td>               </tr>           </tbody>       </table>       <nav>           <ul class=\"pager\">               <li><a href=\"javascript:void(0)\" id=\"ppriv\">\u4e0a\u4e00\u9875</a></li>               <li><a href=\"javascript:void(0)\" id=\"pnext\">\u4e0b\u4e00\u9875</a></li>           </ul>       </nav>   </div></div>";
    private static final String HTML = "<!DOCTYPE html><html lang=\"en\"><head>    <meta charset=\"UTF-8\">    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">    <title>Index</title>    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/bootstrap/css/bootstrap.min.css\">    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/material/css/materialdesignicons.min.css\">    <link rel=\"stylesheet\" href=\"##contextPath##/dist/css/style.css\">    <link rel=\"icon\" href=\"##contextPath##/dist/img/favicon.ico\"></head><body><div class=\"lyear-layout-web\">    <div class=\"lyear-layout-container\">%s%s        <main class=\"lyear-layout-content\">            <div class=\"container-fluid\">                <div class=\"row\">%s%s%s%s                </div>                <div class=\"row\">                    <div class=\"col-lg-6\">%s                    </div>                    <div class=\"col-lg-6\">%s                    </div>                </div>            </div>        </main>    </div></div><script src=\"##contextPath##/plugin/jquery/jquery-3.5.1.js\"></script><script src=\"##contextPath##/plugin/bootstrap/js/bootstrap.min.js\"></script><script src=\"##contextPath##/plugin/scrollbar/js/perfect-scrollbar.min.js\"></script><script src=\"##contextPath##/dist/js/main.js\"></script><script src=\"##contextPath##/dist/js/index.js\"></script><script>   var stime = 0;   var ppage = 0;   var rpage = 0;   var rtpage = 0;   var ptpage = 0;   $(document).ready(function (e) {       stime = new Date(parseInt( $('#duration').text()));       setInterval(\"draw()\", 100);       getRstat(0);       getPstat(0);       $('#rpriv').click(function(){       console.info(rpage);           if(rpage > 0){               getRstat(--rpage);           } else {               rpage = 0;           }       });       $('#rnext').click(function(){       console.info(rpage);           if(rpage < rtpage){               getRstat(++rpage);           } else {               rpage = rtpage;           }       });       $('#ppriv').click(function(){           console.info(ppage);           if(ppage > 0){               getPstat(--ppage);           } else {               ppage = 0;           }       });       $('#pnext').click(function(){           console.info(ppage);           if(ppage < ptpage){               getPstat(++ppage);           } else {               ppage = ptpage;           }       });       $('#logoutBtn').click(function(){           $.get('doLogout', function(result){               if(result.errcode === 0) {                   $(window).attr(\"location\", \"login\");               }           });       });   });   function draw() {       $(\"#duration\").text(duration(stime));   }   function getRstat(pageNo) {       $.get('rstat?pageNo=' + pageNo, function(res){           if(res.errcode == 0) {               var list = res.data.list;               rtpage = res.data.totalPage - 1;               drawRstat(list);           }       });   }   function drawRstat(list) {       if(list.length > 0) {           $('#rstat').empty();           list.forEach((item, idx)=>{               $('#rstat').append(\"<tr><td>\" + item.name+\"</td><td>\" + item.desc+\"</td><td>\" + item.value+\"</td></tr>\");           })       }   }   function getPstat(pageNo) {       $.get('pstat?pageNo=' + pageNo, function(res){           if(res.errcode == 0) {               var list = res.data.list;               ptpage = res.data.totalPage - 1;               drawPstat(list);           }       });   }   function drawPstat(list) {       if(list.length > 0) {           $('#pstat').empty();           list.forEach((item, idx)=>{               $('#pstat').append(\"<tr><td>\" + item.name+\"</td><td>\" + item.desc+\"</td><td>\" + item.value+\"</td></tr>\");           })       }   }</script></body></html>";

    @Override
    protected void doHandle() {
        if (!this.checkAt()) {
            this.renderRedirect("_console/login");
        }
        ServerStat stat = AppServerCore.inst().getServerStat();
        this.renderHtml(String.format(HTML, this.aside(null), this.header(null), this.ctimeStr(stat), this.dailyStr(stat), this.monthlyStr(stat), this.totalStr(stat), rstat_pattern, pstat_pattern).replaceAll("##contextPath##", this.getContextPath()));
    }

    private String ctimeStr(ServerStat stat) {
        return String.format(ctime_pattern, stat.getCtime());
    }

    private String dailyStr(ServerStat stat) {
        return String.format(daily_pattern, stat.getDaily());
    }

    private String monthlyStr(ServerStat stat) {
        return String.format(monthly_pattern, stat.getMonthly());
    }

    private String totalStr(ServerStat stat) {
        return String.format(total_pattern, stat.getTotal());
    }
}

