/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.core.dispatch;

import com.ydn.web.appserver.AbstractController;
import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.annotation.Parameter;
import com.ydn.web.appserver.annotation.RequestMethod;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.ActionContext;
import com.ydn.web.appserver.core.ActionInvocation;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.Dispatcher;
import com.ydn.web.appserver.core.InterceptorChain;
import com.ydn.web.appserver.core.ServerConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDispatcher
implements Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger(ActionDispatcher.class);

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionContext actionContext = ActionContext.getContext();
        if (actionContext == null) {
            actionContext = new ActionContext();
            ActionContext.setContext(actionContext);
        }
        actionContext.setConfiguration(AppServerCore.inst().getServerConfiguration());
        actionContext.setRequest(request);
        actionContext.setResponse(response);
        String route = this.route(AppServerCore.inst().getServerConfiguration(), request);
        Action action = AppServerCore.inst().getActionMappings().find(route);
        if (action == null) {
            AppServerCore.inst().getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        actionContext.setAction(action);
        if (!RequestMethod.ALL.name().equals(action.getAnno().method().name()) && !request.getMethod().equals(action.getAnno().method().name())) {
            AppServerCore.inst().getRenderFactory().getJsonRender(Result.error(400, "\u8bf7\u4f7f\u7528" + action.getAnno().method().name() + "\u65b9\u5f0f")).setContext(request, response).render();
            return;
        }
        for (Parameter parameter : action.getAnno().request()) {
            if (!parameter.required() || actionContext.getParam(parameter.name()) != null) continue;
            AppServerCore.inst().getRenderFactory().getJsonRender(Result.error(400, parameter.name() + "\u5fc5\u9009")).setContext(request, response).render();
            return;
        }
        this.doHandle();
    }

    private String route(ServerConfiguration configuration, HttpServletRequest request) {
        String contextPath = configuration.getContextPath();
        int length = contextPath.length();
        if (!contextPath.startsWith("/")) {
            ++length;
        }
        return request.getRequestURI().substring(length);
    }

    private void doHandle() {
        ActionContext actionContext = ActionContext.getContext();
        AbstractController controller = AppServerCore.inst().getControllerFactory().getController(actionContext.getAction().getClazz());
        if (controller != null) {
            this.execute(controller);
        } else {
            logger.error("\u6ca1\u83b7\u53d6\u5230 {} \u5b9e\u4f8b", (Object)actionContext.getAction().getClazz().getName());
            AppServerCore.inst().getRenderFactory().getJsonRender(Result.error(500, "\u7cfb\u7edf\u5f02\u5e38")).render();
        }
    }

    private void execute(final AbstractController controller) {
        final ActionContext actionContext = ActionContext.getContext();
        InterceptorChain interceptors = AppServerCore.inst().getInterceptorFactory().getInterceptors(actionContext.getAction().getAnno().interceptor());
        try {
            new ActionInvocation(interceptors, actionContext, new ActionInvocation.FinalInvocation(){

                @Override
                public void invoke() throws Exception {
                    actionContext.getAction().getMethod().invoke((Object)controller, new Object[0]);
                }
            }).invoke();
            this.addActionSuccStat(actionContext);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            this.addActionFailStat(actionContext, e);
            AppServerCore.inst().getRenderFactory().getJsonRender(Result.error(500, "\u7cfb\u7edf\u5f02\u5e38")).render();
        }
    }

    private void addActionSuccStat(ActionContext actionContext) {
        AppServerCore.inst().getServerStat().succ(this.route(actionContext.getAction()), actionContext.getEndMillis() - actionContext.getStartMillis());
    }

    private void addActionFailStat(ActionContext actionContext, Exception e) {
        AppServerCore.inst().getServerStat().fail(this.route(actionContext.getAction()), actionContext.getEndMillis() - actionContext.getStartMillis(), e);
    }

    private String route(Action action) {
        return action.getRes().value() + action.getAnno().value();
    }
}

