/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.render;

import com.ydn.web.appserver.render.Render;
import com.ydn.web.appserver.render.RenderException;
import java.io.IOException;

public class ErrorRender
extends Render {
    protected int errorCode;
    protected static final String contentType = "text/html; charset=" + encoding;
    protected static final String version = "<center>\u8bf7\u6c42\u5f02\u5e38</center>";
    protected static final byte[] html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center>\u8bf7\u6c42\u5f02\u5e38</center></body></html>".getBytes();
    protected static final byte[] html500 = "<html><head><title>\u7cfb\u7edf\u5f02\u5e38</title></head><body bgcolor='white'><center><h1>\u7cfb\u7edf\u5f02\u5e38</h1></center></body></html>".getBytes();
    protected static final byte[] html400 = "<html><head><title>400 Bad Request</title></head><body bgcolor='white'><center><h1>400 Bad Request</h1></center><hr><center>\u8bf7\u6c42\u5f02\u5e38</center></body></html>".getBytes();
    protected static final byte[] html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center>\u8bf7\u6c42\u5f02\u5e38</center></body></html>".getBytes();
    protected static final byte[] html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center>\u8bf7\u6c42\u5f02\u5e38</center></body></html>".getBytes();

    public ErrorRender(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public void render() {
        this.response.setStatus(this.errorCode);
        try {
            this.response.setContentType(contentType);
            this.response.getOutputStream().write(this.getErrorHtml());
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    private byte[] getErrorHtml() {
        int errorCode = this.getErrorCode();
        if (errorCode == 404) {
            return html404;
        }
        if (errorCode == 500) {
            return html500;
        }
        if (errorCode == 400) {
            return html400;
        }
        if (errorCode == 401) {
            return html401;
        }
        if (errorCode == 403) {
            return html403;
        }
        return ("<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + version + "</body></html>").getBytes();
    }

    private int getErrorCode() {
        return this.errorCode;
    }
}

