/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.render;

import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.render.Render;
import com.ydn.web.appserver.render.RenderException;
import java.io.IOException;

public class RedirectRender
extends Render {
    private String url;

    public RedirectRender(String url) {
        this.url = url;
    }

    @Override
    public void render() {
        try {
            this.response.sendRedirect(this.redirect());
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    private String redirect() {
        String redirect = !this.url.matches("^http://(.)*|^https://(.)*") ? this.contextPath() + "/" + this.url : this.url;
        return redirect;
    }

    private String contextPath() {
        String path = AppServerCore.inst().getServerConfiguration().getContextPath();
        return path.startsWith("/") ? path : "/" + path;
    }
}

