/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.render;

import com.ydn.web.appserver.render.ContentType;
import com.ydn.web.appserver.render.Render;
import com.ydn.web.appserver.render.RenderException;
import java.io.IOException;

public class TextRender
extends Render {
    private static final String CONTENT_TYPE = "text/plain";
    private String text;
    private String contentType;

    public TextRender(String text) {
        this.text = text;
        this.contentType = CONTENT_TYPE;
    }

    public TextRender(String text, String contentType) {
        this.text = text;
        ContentType ct = ContentType.parse(contentType);
        this.contentType = ct != null ? ct.value() : contentType;
    }

    public TextRender(String text, ContentType contentType) {
        this.text = text;
        this.contentType = contentType.value();
    }

    @Override
    public void render() {
        this.response.setContentType(this.contentType);
        if (!this.contentType.contains("charset")) {
            this.response.setCharacterEncoding(encoding);
        }
        try {
            this.response.getWriter().write(this.text);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }
}

