/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.spring;

import com.ydn.web.appserver.AppServerException;
import com.ydn.web.appserver.WebAppServer;
import com.ydn.web.appserver.spring.SpringControllerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;

public class SpringServerInjector {
    public static final String APPCONTEXT_PROPERTY_NAME = "spring-app-context";
    private static final Logger logger = LoggerFactory.getLogger(SpringServerInjector.class);

    public static void init(WebAppServer server, ApplicationContext applicationContext) {
        server.setProperty(APPCONTEXT_PROPERTY_NAME, applicationContext);
        SpringControllerFactory controllerFactory = new SpringControllerFactory();
        controllerFactory.setApplicationContext(applicationContext);
        server.setControllerFactory(controllerFactory);
    }

    public static void inject(WebAppServer server, String springConfigFile) {
        if (SpringServerInjector.isSpringInjected(server)) {
            return;
        }
        Object context = springConfigFile.startsWith("classpath:") ? new ClassPathXmlApplicationContext(springConfigFile) : new GenericXmlApplicationContext(new String[]{springConfigFile});
        SpringServerInjector.init(server, (ApplicationContext)context);
    }

    public static boolean isSpringInjected(WebAppServer server) {
        return server.getProperty(APPCONTEXT_PROPERTY_NAME) != null && server.getProperty(APPCONTEXT_PROPERTY_NAME) instanceof ApplicationContext;
    }

    public static <T> T getBeanByClass(WebAppServer appServer, String className) {
        ApplicationContext context = (ApplicationContext)appServer.getProperty(APPCONTEXT_PROPERTY_NAME);
        try {
            if (context == null) {
                return null;
            }
            return (T)context.getBean(Class.forName(className));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new AppServerException(e);
        }
    }
}

