/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.util;

import java.util.HashMap;
import java.util.Map;

public class Arguments {
    private Map<String, String> arguments = new HashMap<String, String>();

    public Arguments(String ... args) {
        String argName = "";
        String argValue = "";
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (argName.length() > 0) {
                    this.arguments.put(argName, argValue.trim());
                    argValue = "";
                }
                argName = arg.substring(1);
                continue;
            }
            argValue = argValue + " " + arg;
        }
        if (argValue.length() > 0) {
            this.arguments.put(argName, argValue.trim());
        }
    }

    public void put(String key, String value) {
        this.arguments.put(key, value);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        String value = this.arguments.get(key);
        return value == null ? defaultValue : value;
    }

    public int getInteger(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getString(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean hasOption(String key) {
        return this.arguments.containsKey(key);
    }
}

