/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);
    static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static <T> List<Class<T>> findClasses(Class<T> iface, String ... packageNames) {
        URL[] classPaths;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(packageNames));
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (URL classPathUrl : classPaths = ((URLClassLoader)classLoader).getURLs()) {
            File classPath;
            Enumeration<Object> files = null;
            JarFile module = null;
            try {
                classPath = new File(classPathUrl.toURI());
            }
            catch (URISyntaxException e) {
                log.error("Skipping classPath '" + classPathUrl + "'", (Throwable)e);
                continue;
            }
            if (!classPath.exists()) continue;
            if (classPath.isDirectory()) {
                ArrayList<String> dirListing = new ArrayList<String>();
                ClassUtils.recursivelyListDir(dirListing, classPath, new StringBuffer());
                files = Collections.enumeration(dirListing);
            } else if (classPath.getName().endsWith(".jar")) {
                try {
                    module = new JarFile(classPath);
                    files = module.entries();
                }
                catch (MalformedURLException e) {
                    log.error("Skipping classPath '" + classPathUrl + "'", (Throwable)e);
                }
                catch (IOException e) {
                    log.error("Skipping classPath '" + classPathUrl + "'", (Throwable)e);
                }
            }
            while (files != null && files.hasMoreElements()) {
                Class<?> theClass;
                String fileName = files.nextElement().toString();
                if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
                String className = fileName.replaceAll("/", ".").substring(0, fileName.length() - 6);
                if (!packages.isEmpty() && !ClassUtils.isInPackages(packages, className)) continue;
                try {
                    theClass = Class.forName(className, false, classLoader);
                }
                catch (NoClassDefFoundError e) {
                    log.error("Skipping class '" + className + "'", (Object)e.getMessage());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.error("Skipping class '" + className + "'", (Object)e.getMessage());
                    continue;
                }
                if (result.contains(theClass) || !iface.isAssignableFrom(theClass)) continue;
                result.add(theClass);
            }
            if (module == null) continue;
            try {
                module.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isInPackages(List<String> packages, String className) {
        String classPackage = ClassUtils.getPackageName(className);
        for (String p : packages) {
            if (!classPackage.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private static String getPackageName(String className) {
        if (!className.contains(".")) {
            return className;
        }
        return className.substring(0, className.lastIndexOf("."));
    }

    private static void recursivelyListDir(List<String> dirListing, File dir, StringBuffer relativePath) {
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                int prevLen = relativePath.length();
                ClassUtils.recursivelyListDir(dirListing, file, relativePath.append(prevLen == 0 ? "" : "/").append(file.getName()));
                relativePath.delete(prevLen, relativePath.length());
            }
        } else {
            dirListing.add(relativePath.toString());
        }
    }
}

