/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.web.appserver.util;

import com.ydn.web.appserver.AppServerException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class TripleDESUtil {
    private static final int KEY_SIZE = 24;

    public static byte[] encrypt(String key, String text) {
        byte[] encrypted;
        try {
            Cipher encrypter = TripleDESUtil.createCipher(key, 1);
            encrypted = encrypter.doFinal(text.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new AppServerException(e);
        }
        return encrypted;
    }

    public static String decrypt(String key, byte[] encrypted) {
        String decrypted;
        try {
            Cipher encrypter = TripleDESUtil.createCipher(key, 2);
            decrypted = new String(encrypter.doFinal(encrypted), "UTF-8");
        }
        catch (Exception e) {
            throw new AppServerException(e);
        }
        return decrypted;
    }

    private static Cipher createCipher(String key, int mode) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key.length() > 24) {
            throw new IllegalArgumentException("Key size must be under 24 characters.");
        }
        key = TripleDESUtil.expandSize(key);
        String algorithm = "DESede";
        String transformation = "DESede/CBC/PKCS5Padding";
        IvParameterSpec iv = new IvParameterSpec(new byte[8]);
        byte[] keyValue = key.getBytes();
        DESedeKeySpec keySpec = new DESedeKeySpec(keyValue);
        SecretKey secretKey = SecretKeyFactory.getInstance(algorithm).generateSecret(keySpec);
        Cipher encrypter = Cipher.getInstance(transformation);
        encrypter.init(mode, (Key)secretKey, iv);
        return encrypter;
    }

    private static String expandSize(String key) {
        StringBuilder stringBuilder = new StringBuilder(key);
        while (stringBuilder.length() < 24) {
            stringBuilder.append(" ");
        }
        key = stringBuilder.toString();
        return key;
    }
}

