package com.ydn.web.appserver;

import com.ydn.web.appserver.core.AppServerFactory;
import com.ydn.web.appserver.util.Arguments;
import com.ydn.web.appserver.util.StringUtil;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import static com.ydn.web.appserver.core.ServerConfiguration.*;

/**
 * @author Feng Chen
 */
public class DefaultServerMain {

    private static WebAppServer defaultServer = null;

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments(args);
        defaultServer = createDefaultServer(arguments, "/server.properties");
        defaultServer.start();
    }

    private static WebAppServer createDefaultServer(Arguments arguments, String property) throws IOException {
        Properties properties = combineArgumentsAndProperties(arguments, property);
        return AppServerFactory.createServer(properties);
    }

    private static Properties combineArgumentsAndProperties(Arguments arguments, String property) throws IOException {
        Properties properties;
        String confPath = arguments.getString("conf");
        if (StringUtil.isNotEmpty(confPath)) {
            properties = readPropertyFile(confPath);
        } else {
            InputStream stream = DefaultServerMain.class.getResourceAsStream(property);
            if (stream != null) {
                properties = readPropertyStream(stream);
            } else {
                properties = new Properties();
            }
        }

        String ip = arguments.getString(
                "ip",
                properties.getProperty("ip", DEFAULT_LISTEN_IP)
        );

        int port = arguments.getInteger(
                "port",
                Integer.parseInt(
                        properties.getProperty("port", String.valueOf(DEFAULT_LISTEN_PORT))
                )
        );

        int maxActiveWorkers = arguments.getInteger(
                "max-active-workers",
                Integer.parseInt(
                        properties.getProperty("max-active-workers", String.valueOf(DEFAULT_MAX_PROCESSORS))
                )
        );

        properties.put("ip", ip);
        properties.put("port", port);
        properties.put("max-active-workers", maxActiveWorkers);

        return properties;
    }

    private static Properties readPropertyFile(String confPath) throws IOException {
        FileInputStream stream = new FileInputStream(confPath);
        try {
            return readPropertyStream(stream);
        } finally {
            stream.close();
        }
    }

    private static Properties readPropertyStream(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        return properties;
    }

}
