package com.ydn.web.appserver.annotation;

import java.lang.annotation.*;

/**
 * 请求
 *
 * @author Feng Chen
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface RequestMapping {

    /**
     * 路径
     */
    String value();

    /**
     * 描述
     */
    String desc();

    /**
     * 请求方法
     */
    RequestMethod method() default RequestMethod.GET;

    /**
     * 请求头
     */
    Parameter[] header() default {};

    /**
     * 请求体
     */
    Parameter[] request() default {};

    /**
     * 返回值
     */
    Property[] response() default {};

    /**
     * 表格属性描述
     */
    Sheet[] sheets() default {};

    /**
     * 错误信息
     */
    Error[] errors() default {};

    /**
     * 拦截器
     */
    String[] interceptor() default {};


}
