package com.ydn.web.appserver.captcha;

/**
 * @author Feng Chen
 */
public class CaptchaManager {

    private static CaptchaManager instance = new CaptchaManager();

    private volatile ICaptchaCache captchaCache;

    private CaptchaManager() {

    }

    public static CaptchaManager getInstance() {
        return instance;
    }

    public void setCaptchaCache(ICaptchaCache captchaCache) {
        this.captchaCache = captchaCache;
    }

    public ICaptchaCache getCaptchaCache() {
        if (captchaCache == null) {
            synchronized (CaptchaManager.class) {
                if (captchaCache == null) {
                    captchaCache = new CaptchaCache();
                }
            }
        }
        return captchaCache;
    }
}
