package com.ydn.web.appserver.core;

import com.ydn.web.appserver.AbstractController;
import com.ydn.web.appserver.annotation.Controller;
import com.ydn.web.appserver.annotation.RequestMapping;

import java.lang.reflect.Method;

/**
 * @author Feng Chen
 */
public class Action implements Comparable<Action> {

    private final Class<? extends AbstractController> clazz;

    private final Method method;

    private final Controller res;
    private final RequestMapping anno;

    public Action(Class<? extends AbstractController> clazz, Method method, Controller res, RequestMapping anno) {
        this.clazz = clazz;
        this.method = method;
        this.res = res;
        this.anno = anno;
    }

    public Class<? extends AbstractController> getClazz() {
        return clazz;
    }

    public Method getMethod() {
        return method;
    }

    public Controller getRes() {
        return res;
    }

    public RequestMapping getAnno() {
        return anno;
    }

    @Override
    public int compareTo(Action o) {
        return anno.value().compareTo(o.getAnno().value());
    }

}
