package com.ydn.web.appserver.core;

import com.ydn.web.appserver.annotation.Parameter;
import com.ydn.web.appserver.util.HttpUtil;
import com.ydn.web.appserver.util.MapUtil;
import com.ydn.web.appserver.util.StringUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class ActionContext {

    private static ThreadLocal<ActionContext> threadLocal = new ThreadLocal<>();

    public static void setContext(ActionContext context) {
        threadLocal.set(context);
    }

    public static ActionContext getContext() {
        return threadLocal.get();
    }

    private ServerConfiguration configuration;

    /**
     * post 请求 Data
     */
    private Map<String, Object> data;

    private HttpServletRequest request;

    private HttpServletResponse response;

    private Action action;

    private long startMillis = 0; // 执行开始时间， 0 表示未记录
    private long endMillis = 0;   //执行结束时间， 0 表示未记录

    public ServerConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public long getStartMillis() {
        return startMillis;
    }

    public void setStartMillis(long startMillis) {
        this.startMillis = startMillis;
    }

    public long getEndMillis() {
        return endMillis;
    }

    public void setEndMillis(long endMillis) {
        this.endMillis = endMillis;
    }

    public String getHeader(String key) {
        return request.getHeader(key);
    }

    public String getParam(String key) {
        // 从请求参数中获取
        String value = request.getParameter(key);

        // 从请求体中获取
        if (StringUtil.isEmpty(value)) {
            value = getPostParam(key);
        }

        // 从注解中获取
        if (StringUtil.isEmpty(value)) {
            value = getDefaultParam(key);
        }

        return value;
    }

    public String[] getInterceptors() {
        return action.getAnno().interceptor();
    }

    // SECTION : INNER HELPER

    private String getPostParam(String key) {
        if (data == null) {
            data = HttpUtil.readData(request);
        }
        return MapUtil.getString(data, key);
    }

    private String getDefaultParam(String key) {
        for (Parameter param : action.getAnno().request()) {
            if (param.name().equals(key)) {
                return param.required() ? null : getDefault(param.defaultValue());
            }
        }
        return null;
    }

    private String getDefault(String defaultValue) {
        return StringUtil.isEmpty(defaultValue) ? null : defaultValue;
    }


}
