package com.ydn.web.appserver.core;

import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.core.dispatch.Dispatchers;
import com.ydn.web.appserver.render.DefaultRenderFactory;
import com.ydn.web.appserver.render.RenderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Feng Chen
 */
@SuppressWarnings("unchecked")
public class AppServerCore {

    /**
     * 服务器配置
     */
    private ServerConfiguration serverConfiguration;

    /**
     * Controller 工厂
     */
    private ControllerFactory controllerFactory = new DefaultControllerFactory();

    /**
     * “路由 - 接口" 映射关系
     */
    private ActionMappings actionMappings = new DefaultActionMappings();

    /**
     * 服务器统计信息
     */
    private ServerStat serverStat = new ServerStat();

    /**
     * 渲染工厂
     */
    private RenderFactory renderFactory = new DefaultRenderFactory();

    /**
     * 拦截器工厂
     */
    private InterceptorFactory interceptorFactory = new DefaultInterceptorFactory();

    private static final Logger logger = LoggerFactory.getLogger(AppServerCore.class);

    /**
     * 设置 Controller 工厂类
     *
     * @param controllerFactory
     */
    public void setControllerFactory(ControllerFactory controllerFactory) {
        this.controllerFactory = controllerFactory;
    }

    /**
     * 设置 Controller 类所在的包
     *
     * @param packages
     */
    public void setPackages(String... packages) {
        actionMappings.setPackages(packages);
    }

    /**
     * 添加拦截器
     *
     * @param interceptor
     */
    public void addInterceptor(Interceptor interceptor) {
        interceptorFactory.addInterceptor(interceptor);
    }

    public void addCoreInterceptor(Interceptor interceptor) {
        interceptorFactory.addCoreInterceptor(interceptor);
    }

    public void setServerConfiguration(ServerConfiguration configuration) {
        serverConfiguration = configuration;
    }

    public ServerConfiguration getServerConfiguration() {
        return serverConfiguration;
    }

    public ActionMappings getActionMappings() {
        return actionMappings;
    }

    public RenderFactory getRenderFactory() {
        return renderFactory;
    }

    public ControllerFactory getControllerFactory() {
        return controllerFactory;
    }

    public InterceptorFactory getInterceptorFactory() {
        return interceptorFactory;
    }

    public ServerStat getServerStat() {
        return serverStat;
    }

    private static AppServerCore instance = new AppServerCore();

    private AppServerCore() {

    }

    public static AppServerCore inst() {
        return instance;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getRequestURI().contains("_console")) {

            // 控制台处理
            Dispatchers.inst().handleConsole(request, response);
        } else {

            // 接口处理
            Dispatchers.inst().handleAction(request, response);
        }
    }

}
