package com.ydn.web.appserver.core;

import com.ydn.web.appserver.util.HttpUtil;
import com.ydn.web.appserver.util.MapUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * @author Feng Chen
 */
public class ConsoleContext {

    private static ThreadLocal<ConsoleContext> threadLocal = new ThreadLocal<>();

    public static void setContext(ConsoleContext context) {
        threadLocal.set(context);
    }

    public static ConsoleContext getContext() {
        return threadLocal.get();
    }

    private ServerConfiguration configuration;

    /**
     * post 请求 Data
     */
    private Map<String, Object> data;

    private HttpServletRequest request;

    private HttpServletResponse response;

    public HttpServletRequest getRequest() {
        return request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public String getParam(String key) {
        // 从请求参数中获取
        String value = request.getParameter(key);

        // 从请求体中获取
        if (value == null) {
            value = getPostParam(key);
        }
        return value;
    }

    // SECTION : INNER HELPER

    private String getPostParam(String key) {
        if (data == null) {
            data = HttpUtil.readData(request);
        }
        return MapUtil.getString(data, key);
    }





}
