package com.ydn.web.appserver.core;

import com.ydn.web.appserver.Interceptor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Feng Chen
 */
public class InterceptorChain extends ArrayList<Interceptor> {

    private int pointer = -1;

    public InterceptorChain(List<Interceptor> interceptors) {
        super(interceptors);
    }

    public InterceptorChain(InterceptorChain interceptors) {
        super(interceptors);
    }

    public InterceptorChain() {
    }

    public Interceptor next() {
        if (this.isEmpty()) {
            return null;
        }

        pointer++;
        if (pointer < this.size()) {
            return this.get(pointer);
        } else {
            pointer--;
            return null;
        }
    }

    public int getPointer() {
        return pointer;
    }

    public void reset() {
        pointer = -1;
    }


}
