package com.ydn.web.appserver.core.console;

import com.alibaba.fastjson.JSON;
import com.ydn.web.appserver.annotation.*;
import com.ydn.web.appserver.core.Action;
import com.ydn.web.appserver.core.ConsoleHandler;

import java.util.*;

/**
 * @author Feng Chen
 */
public class ActionHandler extends ConsoleHandler {

    // 面包屑
    private static final String breadcrumb_pattern =
            "<div class=\"row action-header\">" +
                    "   <ol class=\"breadcrumb\">" +
                    "       <li>%s</li>" +
                    "       <li>%s</li>" +
                    "   </ol>" +
                    "</div>";

    private static final String doc_pattern =
            "<div class=\"tab-pane fade in active\" id=\"doc\">" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-20\">请求方式/路径</h3>" +
                    "       <p>" +
                    "           %s" +
                    "           <span class=\"fontsize-16 m-l-5\" id=\"url\">%s</span>" +
                    "       </p>" +
                    "   </div>" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-40\">头部参数</h3>" +
                    "       <table class=\"table table-hover table-bordered\">" +
                    "           <thead class=\"color-gray\">" +
                    "               <tr>" +
                    "                   <th>字段名称</th>" +
                    "                   <th>字段描述</th>" +
                    "                   <th>字段类型</th>" +
                    "                   <th>是否必填</th>" +
                    "                   <th>默认值</th>" +
                    "               </tr>" +
                    "           </thead>" +
                    "           <tbody>" +
                    "%s" +
                    "           </tbody>" +
                    "       </table>" +
                    "   </div>" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-40\">请求参数</h3>" +
                    "       <table class=\"table table-hover table-bordered\">" +
                    "           <thead class=\"color-gray\">" +
                    "               <tr>" +
                    "                   <th>字段名称</th>" +
                    "                   <th>字段描述</th>" +
                    "                   <th>字段类型</th>" +
                    "                   <th>是否必填</th>" +
                    "                   <th>默认值</th>" +
                    "               </tr>" +
                    "           </thead>" +
                    "           <tbody>" +
                    "%s" +
                    "           </tbody>" +
                    "       </table>" +
                    "   </div>" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-40\">返回结果</h3>" +
                    "       <table class=\"table table-hover table-bordered\">" +
                    "           <thead class=\"color-gray\">" +
                    "               <tr>" +
                    "                   <th>属性名称</th>" +
                    "                   <th>属性类型</th>" +
                    "                   <th>属性描述</th>" +
                    "              </tr>" +
                    "           </thead>" +
                    "           <tbody>" +
                    "%s" +
                    "           </tbody>" +
                    "       </table>" +
                    "%s" +
                    "   </div>" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-40\">返回示例</h3>" +
                    "       <pre>%s" +
                    "       </pre>" +
                    "   </div>" +
                    "</div>";

    private static final String ink_pattern =
            "<div class=\"tab-pane fade\" id=\"ink\">" +
                    "%s" +
                    "   <div>" +
                    "       <h3 class=\"magin-v-40\">返回数据</h3>" +
                    "       <pre id=\"res\">" +
                    "       </pre>" +
                    "   </div>" +
                    "</div>";

    private static final String script_pattern =
            " $(\"#btnSub\").click(function () {" +
                    "   $(\"#aform\").validate({" +
                    "       submitHandler: function () {" +
                    "           var p = {}; " +
                    "           var h = {};" +
                    "           var f = $(\"#aform\").serializeArray();" +
                    "           $.each(f, function () { " +
                    "                   if(this.name.indexOf('HEAD_') != -1){" +
                    "                       h[this.name.replace('HEAD_', '')] = this.value;" +
                    "                   } else {" +
                    "                       p[this.name.replace('REQT_', '')] = this.value;" +
                    "                   }" +
                    "           });" +
                    "           $.ajax({" +
                    "               \"type\": \"%s\"," +
                    "               \"url\": \"%s\"," +
                    "               \"dataType\": \"json\"," +
                    "               \"data\": p," +
                    "               \"headers\":h," +
                    "               success: function (result) {" +
                    "                   $(\"#res\").text(JSON.stringify(result, null, 2));" +
                    "               }," +
                    "               error: function () { alert('网络异常'); }" +
                    "           });" +
                    "       }" +
                    "   });" +
                    "});";


    private static final String HTML = "<!DOCTYPE html>" +
            "<html lang=\"en\">" +
            "<head>" +
            "    <meta charset=\"UTF-8\">" +
            "    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">" +
            "    <title>Action</title>" +
            "    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/bootstrap/css/bootstrap.min.css\">" +
            "    <link rel=\"stylesheet\" href=\"##contextPath##/plugin/material/css/materialdesignicons.min.css\">" +
            "    <link rel=\"stylesheet\" href=\"##contextPath##/dist/css/style.css\">" +
            "    <link rel=\"stylesheet\" href=\"##contextPath##/dist/css/action.css\">" +
            "    <link rel=\"icon\" href=\"##contextPath##/dist/img/favicon.ico\">" +
            "</head>" +
            "<body>" +
            "<div class=\"lyear-layout-web\">" +
            "    <div class=\"lyear-layout-container\">" +
            "%s" +
            "%s" +
            "        <main class=\"lyear-layout-content\">" +
            "            <div class=\"container-fluid\">" +
            "%s" +
            "                    <div class=\"action-content\">" +
            "                        <div class=\"row\">" +
            "                            <ul class=\"nav nav-tabs pull-right\">" +
            "                                <li class=\"active\">" +
            "                                    <a href=\"#doc\" data-toggle=\"tab\">接口说明</a>" +
            "                                </li>" +
            "                                <li>" +
            "                                    <a href=\"#ink\" data-toggle=\"tab\">接口调用</a>" +
            "                                </li>" +
            "                            </ul>" +
            "                        </div>" +
            "                        <div class=\"row padding-h-30\">" +
            "                            <div class=\"tab-content\">" +
            "%s" +
            "%s" +
            "                            </div>" +
            "                        </div>" +
            "                    </div>" +
            "            </div>" +
            "        </main>" +
            "    </div>" +
            "</div>" +
            "<script src=\"##contextPath##/plugin/jquery/jquery-3.5.1.js\"></script>" +
            "<script src=\"##contextPath##/plugin/jquery/jquery.validate.js\"></script>" +
            "<script src=\"##contextPath##/plugin/bootstrap/js/bootstrap.min.js\"></script>" +
            "<script src=\"##contextPath##/plugin/scrollbar/js/perfect-scrollbar.min.js\"></script>" +
            "<script src=\"##contextPath##/plugin/chart/js/Chart.js\"></script>" +
            "<script src=\"##contextPath##/dist/js/main.js\"></script>" +
            "<script>" +
            "    $(document).ready(function (e) {" +
            "       $('#url').text(location.host+$('#url').text());" +
            "%s" +
            "       $('#logoutBtn').click(function(){" +
            "           $.get('doLogout', function(result){" +
            "               if(result.errcode === 0) {" +
            "                   $(window).attr(\"location\", \"login\");" +
            "               }" +
            "           });" +
            "       });" +
            "    });" +
            "</script>" +
            "</body>" +
            "</html>";

    @Override
    protected void doHandle() {

        if (!checkAt()) {
            renderRedirect("_console/login");
        }

        Action action = getAction(getString("act"));
        renderHtml(
                String.format(
                        HTML,
                        aside(action),
                        header(action),
                        breadcrumb(action),
                        doc(action),
                        ink(action),
                        script(action)
                ).replaceAll(CONTEXT_PATH, getContextPath())
        );

    }

    private String breadcrumb(Action action) {
        return String.format(breadcrumb_pattern, action.getRes().desc(), action.getAnno().desc());
    }

    private String doc(Action action) {
        return String.format(
                doc_pattern,
                methodStr(action),
                uriStr(action),
                headerStr(action),
                parameterStr(action),
                propertyStr(action),
                sheetStr(action),
                respStr(action)
        );
    }

    private String script(Action action) {
        return String.format(script_pattern, typeStr(action), uriStr(action));
    }

    private String typeStr(Action action) {
        String method = "GET";
        switch (action.getAnno().method().name()) {
            case "POST":
                method = "POST";
                break;
        }
        return method;
    }

    // 方法
    private String methodStr(Action action) {
        StringBuilder builder = new StringBuilder();
        switch (action.getAnno().method().name()) {
            case "ALL":
                builder.append("<span class=\"label label-warning\">ALL</span>");
                break;
            case "GET":
                builder.append("<span class=\"label label-success\">GET</span>");
                break;
            case "POST":
                builder.append("<span class=\"label label-primary\">POST</span>");
                break;
            default:
                builder.append("<span class=\"label label-danger\">" + action.getAnno().method().name() + "</span>");
                break;
        }
        return builder.toString();
    }

    private String uriStr(Action action) {
        return getContextPath() + action.getRes().value() + action.getAnno().value();
    }

    private String headerStr(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().header().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=5>无</td>");
            builder.append("</tr>");
        } else {
            for (Parameter header : action.getAnno().header()) {
                builder.append(headerStr(header));
            }
        }
        return builder.toString();
    }

    // 头部

    private String headerStr(Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("	<td>" + parameter.name() + "</td>");
        builder.append("	<td>" + parameter.desc() + "</td>");
        builder.append("	<td>" + parameter.type().name() + "</td>");
        builder.append("	<td>" + (parameter.required() ? "<span class=\"label label-warning\">必填</span>" : "可选") + "</td>");
        builder.append("	<td>" + parameter.defaultValue() + "</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    private String parameterStr(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().request().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=5>无</td>");
            builder.append("</tr>");
        } else {
            for (Parameter parameter : action.getAnno().request()) {
                builder.append(parameterStr(parameter));
            }
        }
        return builder.toString();
    }

    // 入参

    private String parameterStr(Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("	<td>" + parameter.name() + "</td>");
        builder.append("	<td>" + parameter.desc() + "</td>");
        builder.append("	<td>" + parameter.type().name() + "</td>");
        builder.append("	<td>" + (parameter.required() ? "<span class=\"label label-warning\">必填</span>" : "可选") + "</td>");
        builder.append("	<td>" + parameter.defaultValue() + "</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    // 结果

    private String propertyStr(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().response().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=\"3\">无</td>");
            builder.append("</tr>");
        } else {
            for (Property property : action.getAnno().response()) {
                builder.append(newProperty(property));
            }
        }
        return builder.toString();
    }

    private String newProperty(Property property) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("	<td>" + property.name() + "</td>");
        if (property.type() == PropType.LIST || property.type() == PropType.OBJECT) {
            builder.append("	<td>" + property.type().name() + "(" + property.sheet() + ")" + "</td>");
        } else {
            builder.append("	<td>" + property.type().name() + "</td>");
        }
        builder.append("	<td>" + property.desc() + "</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    // Sheet

    private String sheetStr(Action act) {
        StringBuilder builder = new StringBuilder();
        for (Sheet sheet : act.getAnno().sheets()) {
            builder.append(newSheet(sheet));
        }
        return builder.toString();
    }

    private String newSheet(Sheet sheet) {
        StringBuilder builder = new StringBuilder();
        builder.append("<div>");
        builder.append("	<h4 class=\"magin-v-40\">" + sheet.name() + "</h4>");
        builder.append("	<table class=\"table table-hover table-bordered\">");
        builder.append("		<thead class=\"color-gray\">");
        builder.append("			<tr>");
        builder.append("				<th>属性名称</th>");
        builder.append("				<th>属性类型</th>");
        builder.append("				<th>属性描述</th>");
        builder.append("			</tr>");
        builder.append("		</thead>");
        builder.append("		<tbody>");
        builder.append(newProperties(sheet));
        builder.append("		</tbody>");
        builder.append("	</table>");
        builder.append("</div>");
        return builder.toString();
    }

    private String newProperties(Sheet sheet) {
        StringBuilder builder = new StringBuilder();
        if (sheet.props().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=\"3\">无</td>");
            builder.append("</tr>");
        } else {
            for (Property property : sheet.props()) {
                builder.append(newProperty(property));
            }
        }
        return builder.toString();
    }

    private String ink(Action action) {
        return String.format(ink_pattern, inkStr(action));
    }

    // 调用
    private String inkStr(Action action) {
        StringBuilder builder = new StringBuilder();
        builder.append("<form id=\"aform\" action=\"" + getContextPath() + action.getRes().value() + action.getAnno().value() + "\" method=\"" + action.getAnno().method() + "\" onSubmit=\"return false\">");
        builder.append("<div>");
        builder.append("	<h3 class=\"magin-v-40\">头部参数</h3>");
        builder.append("	<table class=\"table table-hover table-bordered\">");
        builder.append("		<thead class=\"color-gray\">");
        builder.append("			<tr>");
        builder.append("				<th>字段名称</th>");
        builder.append("				<th>字段说明</th>");
        builder.append("				<th>字段类型</th>");
        builder.append("				<th>输入</th>");
        builder.append("			</tr>");
        builder.append("		</thead>");
        builder.append("		<tbody>");
        builder.append(newHeader(action));
        builder.append("		</tbody>");
        builder.append("	</table>");
        builder.append("</div>");
        builder.append("<div>");
        builder.append("	<h3 class=\"magin-v-40\">请求参数</h3>");
        builder.append("	<table class=\"table table-hover table-bordered\">");
        builder.append("		<thead class=\"color-gray\">");
        builder.append("			<tr>");
        builder.append("				<th>字段名称</th>");
        builder.append("				<th>字段说明</th>");
        builder.append("				<th>字段类型</th>");
        builder.append("				<th>输入</th>");
        builder.append("			</tr>");
        builder.append("		</thead>");
        builder.append("		<tbody>");
        builder.append(newRequest(action));
        builder.append("		</tbody>");
        builder.append("	</table>");
        builder.append("</div>");
        builder.append("<div class=\"clearfix\">");
        builder.append("	<button class=\"btn btn-primary pull-right\" id=\"btnSub\">提交</button>");
        builder.append("</div>");
        builder.append("</form>");
        return builder.toString();
    }

    private String newHeader(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().header().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=\"4\">无</td>");
            builder.append("</tr>");
        } else {
            for (Parameter parameter : action.getAnno().header()) {
                builder.append(newParameter(parameter, true));
            }
        }
        return builder.toString();
    }

    private String newRequest(Action action) {
        StringBuilder builder = new StringBuilder();
        if (action.getAnno().request().length == 0) {
            builder.append("<tr>");
            builder.append("	<td colspan=\"4\">无</td>");
            builder.append("</tr>");
        } else {
            for (Parameter parameter : action.getAnno().request()) {
                builder.append(newParameter(parameter, false));
            }
        }
        return builder.toString();
    }

    private String newParameter(Parameter parameter, boolean isHeader) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tr>");
        builder.append("	<td>" + parameter.desc() + "</td>");
        builder.append("	<td>" + parameter.name() + "</td>");
        builder.append("	<td>" + parameter.type().name() + "</td>");
        builder.append("	<td>");
        builder.append("		<input class=\"form-control\" type=\"text\" name=\"" + newPkey(parameter.name(), isHeader) + "\" " + (parameter.required() ? "placeholder=\"必选\" required" : "") + " >");
        builder.append("	</td>");
        builder.append("</tr>");
        return builder.toString();
    }

    private String newPkey(String key, boolean isHeader) {
        return isHeader ? "HEAD_" + key : "REQT_" + key;
    }

    private String respStr(Action action) {
        return JSON.toJSONString(respDemo(action), true);
    }

    private Map<String, Object> respDemo(Action action) {
        Map<String, Object> demo = new HashMap<>();
        for (Property property : action.getAnno().response()) {
            demo.put(property.name(), propDemo(action.getAnno(), property));
        }
        return demo;
    }

    private Map<String, Object> objectDemo(RequestMapping anno, Sheet sheet) {
        Map<String, Object> demo = new HashMap<>();
        for (Property prop : sheet.props()) {
            demo.put(prop.name(), propDemo(anno, prop));
        }
        return demo;
    }

    private List<Map<String, Object>> listDemo(RequestMapping anno, Sheet sheet) {
        Map<String, Object> demo = new HashMap<>();
        for (Property prop : sheet.props()) {
            demo.put(prop.name(), propDemo(anno, prop));
        }
        return Arrays.asList(demo);
    }

    private Object propDemo(RequestMapping anno, Property property) {
        if (property.type() == PropType.STRING) {
            return "";
        } else if (property.type() == PropType.INTEGER) {
            return 0;
        } else if (property.type() == PropType.DECIMAL) {
            return 0.0;
        } else if (property.type() == PropType.DATE) {
            return new Date();
        } else if (property.type() == PropType.OBJECT) {
            return objectDemo(anno, getSheet(property.sheet(), anno));
        } else if (property.type() == PropType.LIST) {
            return listDemo(anno, getSheet(property.sheet(), anno));
        }
        return null;
    }

    private Sheet getSheet(String name, RequestMapping anno) {
        for (Sheet sheet : anno.sheets()) {
            if (sheet.name().equals(name)) {
                return sheet;
            }
        }
        return null;
    }

}
