package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.core.AppServerCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Feng Chen
 */
public class ConsoleHandlers {

    private static ConsoleHandlers instance = new ConsoleHandlers();

    private static final Logger logger = LoggerFactory.getLogger(ConsoleHandlers.class);

    private ConsoleHandlers() {

    }

    public static ConsoleHandlers inst() {
        return instance;
    }

    private AdminLoginHandler adminLoginHandler = new AdminLoginHandler();
    private AdminLogoutHandler adminLogoutHandler = new AdminLogoutHandler();
    private LoginHandler loginHandler = new LoginHandler();
    private IndexHandler indexHandler = new IndexHandler();
    private ActionHandler actionHandler = new ActionHandler();
    private ReqStatHandler rstatHandler = new ReqStatHandler();
    private PerfStatHandler pstatHandler = new PerfStatHandler();

    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        switch (route(request)) {
            case "doLogin":
                adminLoginHandler.handle(request, response);
                break;
            case "doLogout":
                adminLogoutHandler.handle(request, response);
                break;
            case "login":
                loginHandler.handle(request, response);
                break;
            case "index":
                indexHandler.handle(request, response);
                break;
            case "action":
                actionHandler.handle(request, response);
                break;
            case "rstat":
                rstatHandler.handle(request, response);
                break;
            case "pstat":
                pstatHandler.handle(request, response);
                break;
        }
    }


    // SECTION : INNER HELPER

    private String route(HttpServletRequest request) {
        String contextPath = AppServerCore.inst().getServerConfiguration().getContextPath();
        int length = contextPath.length();
        if (!contextPath.startsWith("/")) {
            length++;
        }
        return request.getRequestURI().substring(length + 10);
    }

}
