package com.ydn.web.appserver.core.console;

import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.core.AppServerCore;
import com.ydn.web.appserver.core.ConsoleHandler;
import com.ydn.web.appserver.core.ReqStat;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 请求统计
 *
 * @author Feng Chen
 */
public class ReqStatHandler extends ConsoleHandler {

    private static final int PAGE_SIZE = 10;

    @Override
    protected void doHandle() {

        if (!checkAt()) {
            renderRedirect("_console/login");
        }

        int pageNo = getInt("pageNo");
        List<ReqStat> stats = AppServerCore.inst()
                .getServerStat()
                .getReqStats();

        int totalPage = (int) Math.ceil(stats.size() * 1.0 / PAGE_SIZE);

        List<ReqStat> list = stats.stream()
                .sorted()
                .skip(pageNo * PAGE_SIZE)
                .limit(PAGE_SIZE)
                .collect(Collectors.toList());

        renderJson(Result.success()
                .putData("list", list)
                .putData("totalPage", totalPage)
                .putData("currPage", pageNo)
        );
    }

}
