package com.ydn.web.appserver.core.dispatch;

import com.ydn.web.appserver.core.Dispatcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author Feng Chen
 */
public class Dispatchers {

    public static Dispatchers instance = new Dispatchers();

    private Dispatchers() {

    }

    public static Dispatchers inst() {
        return instance;
    }


    private final Dispatcher consoleDispatcher = new ConsoleDispatcher();
    private final Dispatcher actionDispatcher = new ActionDispatcher();


    public void handleConsole(HttpServletRequest request, HttpServletResponse response) throws Exception {
        consoleDispatcher.dispatch(request, response);
    }

    public void handleAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        actionDispatcher.dispatch(request, response);
    }


}
