package com.ydn.web.appserver.interceptor;

import com.ydn.web.appserver.Interceptor;
import com.ydn.web.appserver.core.ActionInvocation;

import javax.servlet.http.HttpServletResponse;

/**
 * @author Feng Chen
 */
public class CorsInterceptor implements Interceptor {

    @Override
    public String code() {
        return "cors";
    }

    @Override
    public void intercept(ActionInvocation inv) throws Exception {
        HttpServletResponse response = inv.getActionContext().getResponse();
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, PATCH, DELETE, PUT");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");

        inv.invoke();

    }

}
