package com.ydn.web.appserver.render;

import com.ydn.web.appserver.Result;
import com.ydn.web.appserver.captcha.CaptchaRender;

import javax.servlet.ServletContext;

/**
 * @author Feng Chen
 */
public class DefaultRenderFactory implements RenderFactory {

    private ServletContext servletContext;

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public Render getErrorRender(int errCode) {
        return new ErrorRender(errCode);
    }

    @Override
    public Render getTextRender(String text) {
        return new TextRender(text);
    }

    @Override
    public Render getTextRender(String text, String contextType) {
        return new TextRender(text, contextType);
    }

    @Override
    public Render getJsonRender() {
        return new JsonRender(Result.success());
    }

    @Override
    public Render getJsonRender(Result result) {
        return new JsonRender(result);
    }

    @Override
    public Render getStringRender(String text) {
        return new StringRender(text);
    }

    @Override
    public Render getCaptchaRender() {
        return new CaptchaRender();
    }

    @Override
    public Render getCaptchaRender(String key) {
        return new CaptchaRender(key);
    }

    @Override
    public Render getRedirectRender(String url) {
        return new RedirectRender(url);
    }

    @Override
    public Render getNullRender() {
        return new NullRender();
    }

}
