package com.ydn.web.appserver.render;

import com.alibaba.fastjson.JSON;
import com.ydn.web.appserver.Result;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class JsonRender extends Render {

    private static final String contentType = "application/json; charset=" + encoding;

    private Result result;

    public JsonRender(Result result) {
        this.result = result;
    }

    @Override
    public void render() {
        try {
            response.setContentType(contentType);
            response.getWriter().write(JSON.toJSONString(result));
            response.getWriter().flush();
        } catch (IOException e) {
            throw new RenderException(e);
        }
    }
}
