package com.ydn.web.appserver.render;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class TextRender extends Render {

    private static final String CONTENT_TYPE = "text/plain";

    private String text;
    private String contentType;

    public TextRender(String text) {
        this.text = text;
        contentType = CONTENT_TYPE;
    }

    public TextRender(String text, String contentType) {
        this.text = text;
        // 支持简洁写法，例如：xml、js
        ContentType ct = ContentType.parse(contentType);
        this.contentType = (ct != null ? ct.value() : contentType);
    }

    public TextRender(String text, ContentType contentType) {
        this.text = text;
        this.contentType = contentType.value();
    }

    @Override
    public void render() {
        response.setContentType(contentType);
        if (!contentType.contains("charset")) {
            response.setCharacterEncoding(encoding);
        }

        try {
            response.getWriter().write(text);
        } catch (IOException e) {
            throw new RenderException(e);
        }
    }
}
