package com.ydn.web.appserver.util;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

/**
 * @author Feng Chen
 */
public abstract class HttpUtil {

    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    private HttpUtil() {

    }

    public static Map<String, Object> readData(HttpServletRequest request) {
        BufferedReader reader = null;
        try {
            StringBuilder builder = new StringBuilder();
            reader = request.getReader();

            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            return JSON.parseObject(builder.toString());
        } catch (IOException e) {
            logger.error("", e);
            return Collections.emptyMap();
        }
    }


}
