package com.ydn.web.appserver.util;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import java.util.Date;
import java.util.Map;

/**
 * @author Feng Chen
 */
public abstract class JwtUtil {

    private JwtUtil() {

    }

    private static final int UNIT_MS = 1000;

    /**
     * @param claims
     * @param secret
     * @param expireTime 失效时间(秒)
     * @return
     * @throws Exception
     */
    public static String newToken(Map<String, Object> claims, String secret, Long expireTime) throws Exception {
        Date now = new Date();
        Date expire = new Date(now.getTime() + expireTime * UNIT_MS);
        System.out.println(expire);
        return Jwts.builder()
                .setHeaderParam("typ", "JWT")
                .setIssuedAt(now)
                .setExpiration(expire)
                .addClaims(claims)
                .signWith(SignatureAlgorithm.HS512, secret)
                .compact();
    }

    /**
     * 获取数据
     *
     * @param token
     * @param secret
     * @return
     * @throws Exception
     */
    public static Map<String, Object> getClaim(String token, String secret) throws Exception {
        return Jwts.parser()
                .setSigningKey(secret)
                .parseClaimsJws(token)
                .getBody();
    }

}
