/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.websocket;

import com.ydn.websocket.WebSocket;
import com.ydn.websocket.WebSocketListener;
import com.ydn.websocket.drafts.Draft;
import com.ydn.websocket.exceptions.InvalidDataException;
import com.ydn.websocket.framing.Framedata;
import com.ydn.websocket.framing.PingFrame;
import com.ydn.websocket.framing.PongFrame;
import com.ydn.websocket.handshake.ClientHandshake;
import com.ydn.websocket.handshake.HandshakeImpl1Server;
import com.ydn.websocket.handshake.ServerHandshake;
import com.ydn.websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }
}

