/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.websocket;

import com.ydn.websocket.WebSocket;
import com.ydn.websocket.drafts.Draft;
import com.ydn.websocket.exceptions.InvalidDataException;
import com.ydn.websocket.framing.Framedata;
import com.ydn.websocket.framing.PingFrame;
import com.ydn.websocket.handshake.ClientHandshake;
import com.ydn.websocket.handshake.Handshakedata;
import com.ydn.websocket.handshake.ServerHandshake;
import com.ydn.websocket.handshake.ServerHandshakeBuilder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public interface WebSocketListener {
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket var1, Draft var2, ClientHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeReceivedAsClient(WebSocket var1, ClientHandshake var2, ServerHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeSentAsClient(WebSocket var1, ClientHandshake var2) throws InvalidDataException;

    public void onWebsocketMessage(WebSocket var1, String var2);

    public void onWebsocketMessage(WebSocket var1, ByteBuffer var2);

    public void onWebsocketOpen(WebSocket var1, Handshakedata var2);

    public void onWebsocketClose(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketClosing(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketCloseInitiated(WebSocket var1, int var2, String var3);

    public void onWebsocketError(WebSocket var1, Exception var2);

    public void onWebsocketPing(WebSocket var1, Framedata var2);

    public PingFrame onPreparePing(WebSocket var1);

    public void onWebsocketPong(WebSocket var1, Framedata var2);

    public void onWriteDemand(WebSocket var1);

    public InetSocketAddress getLocalSocketAddress(WebSocket var1);

    public InetSocketAddress getRemoteSocketAddress(WebSocket var1);
}

