/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.websocket.extensions;

import com.ydn.websocket.exceptions.InvalidDataException;
import com.ydn.websocket.exceptions.InvalidFrameException;
import com.ydn.websocket.extensions.DefaultExtension;
import com.ydn.websocket.framing.ControlFrame;
import com.ydn.websocket.framing.DataFrame;
import com.ydn.websocket.framing.Framedata;

public abstract class CompressionExtension
extends DefaultExtension {
    @Override
    public void isFrameValid(Framedata inputFrame) throws InvalidDataException {
        if (inputFrame instanceof DataFrame && (inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
        if (inputFrame instanceof ControlFrame && (inputFrame.isRSV1() || inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
    }
}

