/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter.machine;

import me.ahoo.cosid.machine.HostAddressSupplier;
import me.ahoo.cosid.machine.LocalHostAddressSupplier;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.cloud.commons.util.UtilAutoConfiguration"})
@ConditionalOnCosIdEnabled
public class CosIdHostNameAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HostAddressSupplier hostNameSupplier() {
        return LocalHostAddressSupplier.INSTANCE;
    }

    static class CloudUtilHostAddressSupplier
    implements HostAddressSupplier {
        private final InetUtils inetUtils;

        CloudUtilHostAddressSupplier(InetUtils inetUtils) {
            this.inetUtils = inetUtils;
        }

        public String getHostAddress() {
            return this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        }
    }

    @Configuration
    @ConditionalOnClass(value={InetUtils.class})
    static class CloudUtilInstanceIdConfiguration {
        CloudUtilInstanceIdConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={InetUtils.class})
        public HostAddressSupplier hostNameSupplier(InetUtils inetUtils) {
            return new CloudUtilHostAddressSupplier(inetUtils);
        }
    }
}

