/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.redis;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import me.ahoo.cosid.machine.AbstractMachineIdDistributor;
import me.ahoo.cosid.machine.ClockBackwardsSynchronizer;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdLostException;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public class SpringRedisMachineIdDistributor
extends AbstractMachineIdDistributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringRedisMachineIdDistributor.class);
    public static final Resource MACHINE_ID_DISTRIBUTE_SOURCE = new ClassPathResource("machine_id_distribute.lua");
    public static final RedisScript<List> MACHINE_ID_DISTRIBUTE = RedisScript.of((Resource)MACHINE_ID_DISTRIBUTE_SOURCE, List.class);
    public static final Resource MACHINE_ID_REVERT_SOURCE = new ClassPathResource("machine_id_revert.lua");
    public static final RedisScript<Long> MACHINE_ID_REVERT = RedisScript.of((Resource)MACHINE_ID_REVERT_SOURCE, Long.class);
    public static final Resource MACHINE_ID_REVERT_STABLE_SOURCE = new ClassPathResource("machine_id_revert_stable.lua");
    public static final RedisScript<Long> MACHINE_ID_REVERT_STABLE = RedisScript.of((Resource)MACHINE_ID_REVERT_STABLE_SOURCE, Long.class);
    public static final Resource MACHINE_ID_GUARD_SOURCE = new ClassPathResource("machine_id_guard.lua");
    public static final RedisScript<Long> MACHINE_ID_GUARD = RedisScript.of((Resource)MACHINE_ID_GUARD_SOURCE, Long.class);
    private final StringRedisTemplate redisTemplate;

    public SpringRedisMachineIdDistributor(StringRedisTemplate redisTemplate, MachineStateStorage machineStateStorage, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        super(machineStateStorage, clockBackwardsSynchronizer);
        this.redisTemplate = redisTemplate;
    }

    protected MachineState distributeRemote(String namespace, int machineBit, InstanceId instanceId, Duration safeGuardDuration) {
        if (log.isInfoEnabled()) {
            log.info("Distribute Remote instanceId:[{}] - machineBit:[{}] @ namespace:[{}].", new Object[]{instanceId, machineBit, namespace});
        }
        List<String> keys = Collections.singletonList(SpringRedisMachineIdDistributor.hashTag(namespace));
        Object[] values = new Object[]{instanceId.getInstanceId(), String.valueOf(MachineIdDistributor.maxMachineId((int)machineBit)), String.valueOf(System.currentTimeMillis()), String.valueOf(MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()))};
        List state = (List)this.redisTemplate.execute(MACHINE_ID_DISTRIBUTE, keys, values);
        assert (state != null);
        Preconditions.checkNotNull((Object)state, (Object)"state can not be null!");
        Preconditions.checkState((!state.isEmpty() ? 1 : 0) != 0, (Object)"state can not be empty!");
        Long machineId = (Long)state.get(0);
        assert (null != machineId);
        int realMachineId = machineId.intValue();
        if (realMachineId == -1) {
            throw new MachineIdOverflowException(MachineIdDistributor.totalMachineIds((int)machineBit), instanceId);
        }
        long lastStamp = -1L;
        if (state.size() == 2) {
            lastStamp = (Long)state.get(1);
        }
        MachineState machineState = MachineState.of((int)realMachineId, (long)lastStamp);
        if (log.isInfoEnabled()) {
            log.info("Distribute Remote machineState:[{}] - instanceId:[{}] - machineBit:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, machineBit, namespace});
        }
        return machineState;
    }

    protected void revertRemote(String namespace, InstanceId instanceId, MachineState machineState) {
        long lastStamp;
        if (log.isInfoEnabled()) {
            log.info("Revert Remote [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        RedisScript<Long> script = MACHINE_ID_REVERT;
        if (instanceId.isStable()) {
            script = MACHINE_ID_REVERT_STABLE;
        }
        if (ClockBackwardsSynchronizer.getBackwardsTimeStamp((long)(lastStamp = machineState.getLastTimeStamp())) < 0L) {
            lastStamp = System.currentTimeMillis();
        }
        List<String> keys = Collections.singletonList(SpringRedisMachineIdDistributor.hashTag(namespace));
        Object[] values = new Object[]{instanceId.getInstanceId(), String.valueOf(lastStamp)};
        this.redisTemplate.execute(script, keys, values);
    }

    protected void guardRemote(String namespace, InstanceId instanceId, MachineState machineState, Duration safeGuardDuration) {
        Object[] values;
        List<String> keys;
        Long affected;
        if (log.isDebugEnabled()) {
            log.debug("Guard Remote [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        if (null != (affected = (Long)this.redisTemplate.execute(MACHINE_ID_GUARD, keys = Collections.singletonList(SpringRedisMachineIdDistributor.hashTag(namespace)), values = new Object[]{instanceId.getInstanceId(), String.valueOf(machineState.getLastTimeStamp())})) && 0L == affected) {
            throw new MachineIdLostException(namespace, instanceId, machineState);
        }
    }

    public static String hashTag(String key) {
        return "{" + key + "}";
    }
}

