/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.buffer.BufferReceivedListener;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.shaded.guava18.com.google.common.io.Closer;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierAligner;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.CheckpointBarrierUnaligner;

class AlternatingCheckpointBarrierHandler
extends CheckpointBarrierHandler {
    private final CheckpointBarrierAligner alignedHandler;
    private final CheckpointBarrierUnaligner unalignedHandler;
    private CheckpointBarrierHandler activeHandler;
    private long lastSeenBarrierId;

    AlternatingCheckpointBarrierHandler(CheckpointBarrierAligner alignedHandler, CheckpointBarrierUnaligner unalignedHandler, AbstractInvokable invokable) {
        super(invokable);
        this.alignedHandler = alignedHandler;
        this.activeHandler = this.alignedHandler;
        this.unalignedHandler = unalignedHandler;
    }

    @Override
    public void releaseBlocksAndResetBarriers() throws IOException {
        this.activeHandler.releaseBlocksAndResetBarriers();
    }

    @Override
    public boolean isBlocked(InputChannelInfo channelInfo) {
        return this.activeHandler.isBlocked(channelInfo);
    }

    @Override
    public void processBarrier(CheckpointBarrier receivedBarrier, InputChannelInfo channelInfo) throws Exception {
        if (receivedBarrier.getId() < this.lastSeenBarrierId) {
            return;
        }
        this.lastSeenBarrierId = receivedBarrier.getId();
        CheckpointBarrierHandler previousHandler = this.activeHandler;
        CheckpointBarrierHandler checkpointBarrierHandler = this.activeHandler = receivedBarrier.isCheckpoint() ? this.unalignedHandler : this.alignedHandler;
        if (previousHandler != this.activeHandler) {
            previousHandler.abortPendingCheckpoint(this.lastSeenBarrierId, new CheckpointException(String.format("checkpoint subsumed by %d", this.lastSeenBarrierId), CheckpointFailureReason.CHECKPOINT_DECLINED_SUBSUMED));
        }
        this.activeHandler.processBarrier(receivedBarrier, channelInfo);
    }

    @Override
    public void processCancellationBarrier(CancelCheckpointMarker cancelBarrier) throws Exception {
        this.activeHandler.processCancellationBarrier(cancelBarrier);
    }

    @Override
    public void processEndOfPartition() throws Exception {
        this.alignedHandler.processEndOfPartition();
        this.unalignedHandler.processEndOfPartition();
    }

    @Override
    public long getLatestCheckpointId() {
        return this.activeHandler.getLatestCheckpointId();
    }

    @Override
    public long getAlignmentDurationNanos() {
        return this.activeHandler.getAlignmentDurationNanos();
    }

    @Override
    public long getCheckpointStartDelayNanos() {
        return this.activeHandler.getCheckpointStartDelayNanos();
    }

    @Override
    public boolean hasInflightData(long checkpointId, InputChannelInfo channelInfo) {
        return this.unalignedHandler.hasInflightData(checkpointId, channelInfo);
    }

    @Override
    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        return this.unalignedHandler.getAllBarriersReceivedFuture(checkpointId);
    }

    @Override
    public Optional<BufferReceivedListener> getBufferReceivedListener() {
        return this.unalignedHandler.getBufferReceivedListener();
    }

    @Override
    protected boolean isCheckpointPending() {
        return this.activeHandler.isCheckpointPending();
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.alignedHandler);
            closer.register((Closeable)this.unalignedHandler);
            closer.register(() -> super.close());
        }
    }
}

