/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventsubscription.service.impl;

import java.util.Date;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryProperty;
import org.flowable.eventsubscription.service.impl.util.CommandContextUtil;

public class EventSubscriptionQueryImpl
extends AbstractQuery<EventSubscriptionQuery, EventSubscription>
implements EventSubscriptionQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String eventType;
    protected String eventName;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String activityId;
    protected String subScopeId;
    protected String scopeId;
    protected String scopeDefinitionId;
    protected String scopeType;
    protected Date createdBefore;
    protected Date createdAfter;
    protected String tenantId;

    public EventSubscriptionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public EventSubscriptionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public EventSubscriptionQueryImpl id(String id) {
        if (id == null) {
            throw new FlowableIllegalArgumentException("Provided event subscription id is null");
        }
        this.id = id;
        return this;
    }

    public EventSubscriptionQueryImpl eventType(String eventType) {
        if (eventType == null) {
            throw new FlowableIllegalArgumentException("Provided event type is null");
        }
        this.eventType = eventType;
        return this;
    }

    public EventSubscriptionQueryImpl eventName(String eventName) {
        if (eventName == null) {
            throw new FlowableIllegalArgumentException("Provided event name is null");
        }
        this.eventName = eventName;
        return this;
    }

    public EventSubscriptionQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    public EventSubscriptionQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public EventSubscriptionQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public EventSubscriptionQueryImpl activityId(String activityId) {
        if (activityId == null) {
            throw new FlowableIllegalArgumentException("Provided activity id is null");
        }
        this.activityId = activityId;
        return this;
    }

    public EventSubscriptionQueryImpl subScopeId(String subScopeId) {
        if (this.scopeId == null) {
            throw new FlowableIllegalArgumentException("Provided sub scope id is null");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    public EventSubscriptionQueryImpl scopeId(String scopeId) {
        if (scopeId == null) {
            throw new FlowableIllegalArgumentException("Provided scope id is null");
        }
        this.scopeId = scopeId;
        return this;
    }

    public EventSubscriptionQueryImpl scopeDefinitionId(String scopeDefinitionId) {
        if (scopeDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided scope definition id is null");
        }
        this.scopeDefinitionId = scopeDefinitionId;
        return this;
    }

    public EventSubscriptionQueryImpl scopeType(String scopeType) {
        if (scopeType == null) {
            throw new FlowableIllegalArgumentException("Provided scope type is null");
        }
        this.scopeType = scopeType;
        return this;
    }

    public EventSubscriptionQueryImpl createdBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("created before time is null");
        }
        this.createdBefore = beforeTime;
        return this;
    }

    public EventSubscriptionQueryImpl createdAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("created after time is null");
        }
        this.createdAfter = afterTime;
        return this;
    }

    public EventSubscriptionQueryImpl tenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public EventSubscriptionQuery orderById() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.ID);
    }

    public EventSubscriptionQuery orderByExecutionId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.EXECUTION_ID);
    }

    public EventSubscriptionQuery orderByProcessInstanceId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.PROCESS_INSTANCE_ID);
    }

    public EventSubscriptionQuery orderByProcessDefinitionId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.PROCESS_DEFINITION_ID);
    }

    public EventSubscriptionQuery orderByCreateDate() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.CREATED);
    }

    public EventSubscriptionQuery orderByTenantId() {
        return (EventSubscriptionQuery)this.orderBy(EventSubscriptionQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return CommandContextUtil.getEventSubscriptionEntityManager(commandContext).findEventSubscriptionCountByQueryCriteria(this);
    }

    public List<EventSubscription> executeList(CommandContext commandContext) {
        return CommandContextUtil.getEventSubscriptionEntityManager(commandContext).findEventSubscriptionsByQueryCriteria(this);
    }

    public String getId() {
        return this.id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getScopeDefinitionId() {
        return this.scopeDefinitionId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

