/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.identityscope.IdentityScope;
import org.greenrobot.greendao.identityscope.IdentityScopeLong;
import org.greenrobot.greendao.identityscope.IdentityScopeObject;
import org.greenrobot.greendao.identityscope.IdentityScopeType;
import org.greenrobot.greendao.internal.TableStatements;

public final class DaoConfig
implements Cloneable {
    public final Database db;
    public final String tablename;
    public final Property[] properties;
    public final String[] allColumns;
    public final String[] pkColumns;
    public final String[] nonPkColumns;
    public final Property pkProperty;
    public final boolean keyIsNumeric;
    public final TableStatements statements;
    private IdentityScope<?, ?> identityScope;

    public DaoConfig(Database db, Class<? extends AbstractDao<?, ?>> daoClass) {
        this.db = db;
        try {
            Class<?> type;
            this.tablename = (String)daoClass.getField("TABLENAME").get(null);
            Property[] properties = DaoConfig.reflectProperties(daoClass);
            this.properties = properties;
            this.allColumns = new String[properties.length];
            ArrayList<String> pkColumnList = new ArrayList<String>();
            ArrayList<String> nonPkColumnList = new ArrayList<String>();
            Property lastPkProperty = null;
            for (int i = 0; i < properties.length; ++i) {
                String name;
                Property property = properties[i];
                this.allColumns[i] = name = property.columnName;
                if (property.primaryKey) {
                    pkColumnList.add(name);
                    lastPkProperty = property;
                    continue;
                }
                nonPkColumnList.add(name);
            }
            String[] nonPkColumnsArray = new String[nonPkColumnList.size()];
            this.nonPkColumns = nonPkColumnList.toArray(nonPkColumnsArray);
            String[] pkColumnsArray = new String[pkColumnList.size()];
            this.pkColumns = pkColumnList.toArray(pkColumnsArray);
            this.pkProperty = this.pkColumns.length == 1 ? lastPkProperty : null;
            this.statements = new TableStatements(db, this.tablename, this.allColumns, this.pkColumns);
            this.keyIsNumeric = this.pkProperty != null ? (type = this.pkProperty.type).equals(Long.TYPE) || type.equals(Long.class) || type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Byte.TYPE) || type.equals(Byte.class) : false;
        }
        catch (Exception e) {
            throw new DaoException("Could not init DAOConfig", e);
        }
    }

    private static Property[] reflectProperties(Class<? extends AbstractDao<?, ?>> daoClass) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Class<?> propertiesClass = Class.forName(daoClass.getName() + "$Properties");
        Field[] fields = propertiesClass.getDeclaredFields();
        ArrayList<Property> propertyList = new ArrayList<Property>();
        int modifierMask = 9;
        for (Field field : fields) {
            Object fieldValue;
            if ((field.getModifiers() & 9) != 9 || !((fieldValue = field.get(null)) instanceof Property)) continue;
            propertyList.add((Property)fieldValue);
        }
        Property[] properties = new Property[propertyList.size()];
        for (Property property : propertyList) {
            if (properties[property.ordinal] != null) {
                throw new DaoException("Duplicate property ordinals");
            }
            properties[property.ordinal] = property;
        }
        return properties;
    }

    public DaoConfig(DaoConfig source) {
        this.db = source.db;
        this.tablename = source.tablename;
        this.properties = source.properties;
        this.allColumns = source.allColumns;
        this.pkColumns = source.pkColumns;
        this.nonPkColumns = source.nonPkColumns;
        this.pkProperty = source.pkProperty;
        this.statements = source.statements;
        this.keyIsNumeric = source.keyIsNumeric;
    }

    public DaoConfig clone() {
        return new DaoConfig(this);
    }

    public IdentityScope<?, ?> getIdentityScope() {
        return this.identityScope;
    }

    public void clearIdentityScope() {
        IdentityScope<?, ?> identityScope = this.identityScope;
        if (identityScope != null) {
            identityScope.clear();
        }
    }

    public void setIdentityScope(IdentityScope<?, ?> identityScope) {
        this.identityScope = identityScope;
    }

    public void initIdentityScope(IdentityScopeType type) {
        if (type == IdentityScopeType.None) {
            this.identityScope = null;
        } else if (type == IdentityScopeType.Session) {
            this.identityScope = this.keyIsNumeric ? new IdentityScopeLong() : new IdentityScopeObject();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
        }
    }
}

