
package com.asiainfo.ssh2.channel;

/**
 * @author Feng Chen
 */
public class Channel {

    static final int STATE_OPENING = 1;
    static final int STATE_OPEN = 2;
    static final int STATE_CLOSED = 4;

    static final int CHANNEL_BUFFER_SIZE = 30000;

    final ChannelManager cm;
    final ChannelOutputStream stdinStream;
    final ChannelInputStream stdoutStream;
    final ChannelInputStream stderrStream;

    int localID = -1;
    int remoteID = -1;

    final Object channelSendLock = new Object();
    boolean closeMessageSent = false;

    final byte[] msgWindowAdjust = new byte[9];

    // If you access (read or write) any of the following fields, then you have
    // to synchronize on the channel.

    int state = STATE_OPENING;

    boolean closeMessageRecv = false;

    /* This is a stupid implementation. At the moment we can only wait
     * for one pending request per channel.
     */
    int successCounter = 0;
    int failedCounter = 0;

    int localWindow = 0; /* locally, we use a small window, < 2^31 */
    long remoteWindow = 0; /* long for readable  2^32 - 1 window support */

    int localMaxPacketSize = -1;
    int remoteMaxPacketSize = -1;

    final byte[] stdoutBuffer = new byte[CHANNEL_BUFFER_SIZE];
    final byte[] stderrBuffer = new byte[CHANNEL_BUFFER_SIZE];

    int stdoutReadpos = 0;
    int stdoutWritepos = 0;
    int stderrReadpos = 0;
    int stderrWritepos = 0;

    boolean EOF = false;

    Integer exit_status;

    String exit_signal;

    // we keep the x11 cookie so that this channel can be closed when this
    // specific x11 forwarding gets stopped

    String hexX11FakeCookie;

    // reasonClosed is special, since we sometimes need to access it
    // while holding the channelSendLock.
    // We protect it with a private short term lock.

    private final Object reasonClosedLock = new Object();
    private String reasonClosed = null;

    public Channel(ChannelManager cm) {
        this.cm = cm;

        this.localWindow = CHANNEL_BUFFER_SIZE;
        this.localMaxPacketSize = 35000 - 1024; // leave enough slack

        this.stdinStream = new ChannelOutputStream(this);
        this.stdoutStream = new ChannelInputStream(this, false);
        this.stderrStream = new ChannelInputStream(this, true);
    }

	/* Methods to allow access from classes outside of this package */

    public ChannelInputStream getStderrStream() {
        return stderrStream;
    }

    public ChannelOutputStream getStdinStream() {
        return stdinStream;
    }

    public ChannelInputStream getStdoutStream() {
        return stdoutStream;
    }

    public String getExitSignal() {
        synchronized (this) {
            return exit_signal;
        }
    }

    public Integer getExitStatus() {
        synchronized (this) {
            return exit_status;
        }
    }

    public String getReasonClosed() {
        synchronized (reasonClosedLock) {
            return reasonClosed;
        }
    }

    public void setReasonClosed(String reasonClosed) {
        synchronized (reasonClosedLock) {
            if (this.reasonClosed == null)
                this.reasonClosed = reasonClosed;
        }
    }
}
