
package com.asiainfo.ssh2.packets;

import java.io.IOException;

/**
 * @author Feng Chen
 */
public class PacketIgnore {

    byte[] payload;

    byte[] body;

    public void setBody(byte[] body) {
        this.body = body;
        payload = null;
    }

    public PacketIgnore(byte payload[], int off, int len) throws IOException {
        this.payload = new byte[len];
        System.arraycopy(payload, off, this.payload, 0, len);

        TypesReader tr = new TypesReader(payload, off, len);

        int packet_type = tr.readByte();

        if (packet_type != Packets.SSH_MSG_IGNORE)
            throw new IOException("This is not a SSH_MSG_IGNORE packet! (" + packet_type + ")");
    }

    public byte[] getPayload() {
        if (payload == null) {
            TypesWriter tw = new TypesWriter();
            tw.writeByte(Packets.SSH_MSG_IGNORE);
            tw.writeString(body, 0, body.length);
            payload = tw.getBytes();
        }
        return payload;
    }
}
